/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.imageview;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.imageview.ImageViewCanvas;
import org.jkiss.dbeaver.ui.controls.imageview.SWTImageViewer;

public class ImageActionDelegate
extends Action {
    public static final String TOOLBAR_ZOOMIN = "toolbar.zoomin";
    public static final String TOOLBAR_ZOOMOUT = "toolbar.zoomout";
    public static final String TOOLBAR_FIT = "toolbar.fit";
    public static final String TOOLBAR_ROTATE = "toolbar.rotate";
    public static final String TOOLBAR_ORIGINAL = "toolbar.original";
    public SWTImageViewer imageViewControl = null;
    public String id;

    public ImageActionDelegate(SWTImageViewer viewControl, String id, String name, DBPImage image) {
        super(name, DBeaverIcons.getImageDescriptor((DBPImage)image));
        this.imageViewControl = viewControl;
        this.id = id;
    }

    public void run() {
        ImageViewCanvas imageViewCanvas = this.imageViewControl.getCanvas();
        if (imageViewCanvas.getSourceImage() == null) {
            return;
        }
        if (this.id.equals(TOOLBAR_ZOOMIN)) {
            imageViewCanvas.zoomIn();
        } else if (this.id.equals(TOOLBAR_ZOOMOUT)) {
            imageViewCanvas.zoomOut();
        } else if (this.id.equals(TOOLBAR_FIT)) {
            imageViewCanvas.fitCanvas();
        } else if (this.id.equals(TOOLBAR_ROTATE)) {
            ImageData src = imageViewCanvas.getSourceImage().getImageData();
            if (src == null) {
                return;
            }
            PaletteData srcPal = src.palette;
            PaletteData destPal = srcPal.isDirect ? new PaletteData(srcPal.redMask, srcPal.greenMask, srcPal.blueMask) : new PaletteData(srcPal.getRGBs());
            ImageData dest = new ImageData(src.height, src.width, src.depth, destPal);
            int i = 0;
            while (i < src.width) {
                int j = 0;
                while (j < src.height) {
                    int pixel = src.getPixel(i, j);
                    dest.setPixel(j, src.width - 1 - i, pixel);
                    ++j;
                }
                ++i;
            }
            imageViewCanvas.updateImage(dest);
        } else if (this.id.equals(TOOLBAR_ORIGINAL)) {
            imageViewCanvas.showOriginal();
        }
    }
}

