# frozen_string_literal: true

class CreateVulnerabilityArchiveExports < Gitlab::Database::Migration[2.2]
  CREATE_TABLE_OPTIONS = {
    primary_key: %i[id partition_number],
    options: 'PARTITION BY LIST (partition_number)'
  }.freeze

  milestone '17.10'

  def up
    create_table :vulnerability_archive_exports, **CREATE_TABLE_OPTIONS do |t| # rubocop:disable Migration/EnsureFactoryForTable -- false positive
      t.bigserial :id, null: false
      t.bigint :partition_number, null: false, default: 1
      t.timestamps_with_timezone null: false
      t.datetime_with_timezone :started_at
      t.datetime_with_timezone :finished_at
      t.bigint :project_id, null: false, index: true
      t.bigint :author_id, null: false, index: true
      t.daterange :date_range, null: false
      t.integer :file_store, limit: 2
      t.integer :format, limit: 2
      t.text :file, limit: 255
      t.text :status, limit: 8

      t.index :status
    end

    connection.execute(<<~SQL)
      CREATE TABLE IF NOT EXISTS gitlab_partitions_dynamic.vulnerability_archive_exports_1
      PARTITION OF vulnerability_archive_exports
      FOR VALUES IN (1);
    SQL
  end

  def down
    drop_table :vulnerability_archive_exports
  end
end
