# frozen_string_literal: true

class DropTmpIndexVulnerabilityOverlongTitleHtml < Gitlab::Database::Migration[2.2]
  milestone '17.6'

  disable_ddl_transaction!

  TABLE_NAME = 'vulnerabilities'
  INDEX_NAME = 'tmp_index_vulnerability_overlong_title_html'

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, [:id], name: INDEX_NAME, where: 'length(title_html) > 800'
  end
end
