---
stage: Plan
group: Optimize
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 生産性分析
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

生産性分析には、グループのマージリクエストに関する情報が表示されます。

生産性分析を使用して、以下を特定します:

- マージリクエストがマージされるまでにかかる時間に基づいて、開発ベロシティを把握します。
- マージリクエストに時間がかかる潜在的な原因を特定します。
- マージに最も時間がかかる、または最も変更を含む作成者、ラベル、またはマイルストーンを特定します。

プロジェクトのマージリクエストデータを表示するには、[merge request analytics](merge_request_analytics.md)を使用してください。

## チャート {#charts}

生産性分析には、次のチャートが表示されます:

- 以下を示す棒チャート:
  - マージまでの日数別のマージリクエスト数。
  - コミット、コメント、およびマージ日時の間隔。
  - コミット数、コード行、および変更されたファイル数。
- 1日あたりのマージリクエストメトリクス数（マージリクエストごとのコミット数など）を示す散布図（マージ日）。
- マージリクエストのタイトル、マージまでの時間、およびコミット、コメント、およびマージ日時の間隔を一覧表示するテーブル。

![時間の経過に伴うマージリクエストの生産性分析チャート](img/productivity_analytics_mrs_v17_9.png)

## 生産性分析を表示 {#view-productivity-analytics}

前提要件:

- グループのレポーターロール以上が必要です。

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**分析** > **生産性分析**を選択します。
1. オプション。結果をフィルタリング:

- 特定のプロジェクトの分析を表示するには、**プロジェクト**ドロップダウンリストから、プロジェクトを選択します。
- 作成者、マイルストーン、またはラベルで結果をフィルタリングするには、**結果をフィルタリング**を選択して、値を入力します。
- 日付範囲を調整するには:
  - **From**フィールドで、開始日を選択します。
  - **To**フィールドで、終了日を選択します。
