---
stage: Developer Experience
group: API
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: "List of community-maintained client libraries for the GitLab REST API."
title: REST API third-party clients
---

{{< details >}}

- Tier: Free
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

You can integrate third-party API client libraries with GitLab. The following libraries are
maintained by community members and not officially supported by GitLab. Report bugs and feature
proposals to the respective projects.

For questions about these integrations, use the [GitLab community forum](https://forum.gitlab.com/).

Administrators can monitor usage of these API clients by
[parsing logs](../../administration/logs/log_parsing.md#print-top-api-user-agents).

## `C#`

- [`GitLabApiClient`](https://github.com/nmklotas/GitLabApiClient)
- [`NGitLab`](https://github.com/ubisoft/NGitLab)

## Go

- GitLab [`client-go`](https://gitlab.com/gitlab-org/api/client-go)

## Haskell

- [`gitlab-haskell`](https://hackage.haskell.org/package/gitlab-haskell)

## Java

- [`gitlab4j-api`](https://github.com/gmessner/gitlab4j-api)
- [`java-gitlab-api`](https://github.com/timols/java-gitlab-api)

## Node.js

- [`gitlab-yaac`](https://www.npmjs.com/package/gitlab-yaac)
- [`backbone-gitlab`](https://github.com/oreillymedia/backbone-gitlab)
- [`@gitbeaker/rest`](https://www.npmjs.com/package/@gitbeaker/rest)

## Perl

- [`GitLab::API::v4`](https://metacpan.org/pod/GitLab::API::v4)

## PHP

- [`php-gitlab-api`](https://github.com/GitLabPHP/Client)

## Python

- [`python-gitlab`](https://github.com/python-gitlab/python-gitlab)
  - Blog post: [Efficient DevSecOps workflows: Hands-on `python-gitlab` API automation](https://about.gitlab.com/blog/2023/02/01/efficient-devsecops-workflows-hands-on-python-gitlab-api-automation/)
- [`libsaas_gitlab`](https://gitlab.com/bor-sh-infrastructure/libsaas_gitlab)

## Ruby

- [Ruby wrapper and CLI for the GitLab REST API](https://github.com/NARKOZ/gitlab)

## Rust

- [`gitlab` crate](https://crates.io/crates/gitlab/)

## Swift

- [`RxGitLabKit`](https://github.com/Qase/RxGitLabKit)
