/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.cmd.Command;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.DeleteFinalRangeCmd;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.RearrangePointsCmd;
import tim.prune.cmd.SetSegmentsCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.function.Describer;

public class ShuffleAndCropCmd
extends CompoundCommand {
    private final List<Integer> _indexesToDelete = new ArrayList<Integer>();

    public ShuffleAndCropCmd(List<Integer> list, List<Integer> list2, List<PointFlag> list3) {
        List<Integer> list4 = ShuffleAndCropCmd.makeTotalIndexes(list, list2);
        this.addCommand(new RearrangePointsCmd(list4));
        this.addCommand(new DeleteFinalRangeCmd(list2.size()));
        if (list3 != null && !list3.isEmpty()) {
            this.addCommand(new SetSegmentsCmd(list3));
        }
        this._indexesToDelete.addAll(list2);
        Describer describer = new Describer("confirm.deletepoint.single", "confirm.deletepoint.multi");
        this.setConfirmText(describer.getDescriptionWithCount(list2.size()));
        Describer describer2 = new Describer("undo.deletepoint", "undo.deletepoints");
        this.setDescription(describer2.getDescriptionWithCount(list2.size()));
    }

    private static List<Integer> makeTotalIndexes(List<Integer> list, List<Integer> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        for (int n : this._indexesToDelete) {
            arrayList.add(trackInfo.getTrack().getPoint(n));
        }
        return this.makeInverse(trackInfo, null, new AppendRangeCmd(arrayList), null);
    }
}

