/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldGpx;
import tim.prune.data.FileInfo;
import tim.prune.data.MediaObject;
import tim.prune.data.Selection;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.ProgressDialog;
import tim.prune.save.SettingsForExport;
import tim.prune.save.xml.XmlUtils;

public abstract class GpxWriter {
    private final ProgressDialog _progress;
    private final SettingsForExport _settings;
    private int _selectionStart = -1;
    private int _selectionEnd = -1;
    protected static final String GPX_CREATOR = "GpsPrune v26.1 activityworkshop.net";

    public GpxWriter(ProgressDialog progressDialog, SettingsForExport settingsForExport) {
        this._progress = progressDialog;
        this._settings = settingsForExport;
    }

    protected abstract String getDefaultGpxHeader();

    protected abstract String getGpxHeader(FileInfo var1);

    public int exportData(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, String string, String string2, FileInfo fileInfo) throws IOException {
        outputStreamWriter.write(GpxWriter.getXmlHeaderString(outputStreamWriter));
        String string3 = this.getGpxHeaderString(fileInfo);
        outputStreamWriter.write(string3);
        String string4 = GpxWriter.isEmpty(string) ? "GpsPruneTrack" : XmlUtils.fixCdata(string);
        String string5 = GpxWriter.isEmpty(string2) ? "Export from GpsPrune" : XmlUtils.fixCdata(string2);
        this.writeMetadata(outputStreamWriter, string4, string5);
        this.setSelectionRange(trackInfo.getSelection());
        Track track = trackInfo.getTrack();
        int n = track.getNumPoints();
        if (this._progress != null) {
            this._progress.setMaximumValue(n);
        }
        int n2 = 0;
        if (this._settings.getExportWaypoints()) {
            n2 += this.writeWaypoints(outputStreamWriter, track);
        }
        if (this._settings.getExportTrackPoints() || this._settings.getExportPhotoPoints() || this._settings.getExportAudioPoints()) {
            n2 += this.writeTrackPoints(outputStreamWriter, track, string4);
        }
        outputStreamWriter.write("</gpx>\n");
        return n2;
    }

    private void setSelectionRange(Selection selection) {
        this._selectionStart = this._settings.getExportJustSelection() ? selection.getStart() : -1;
        this._selectionEnd = this._settings.getExportJustSelection() ? selection.getEnd() : -1;
    }

    private boolean shouldExportIndex(int n) {
        if (this._selectionStart == -1 || this._selectionEnd == -1) {
            return true;
        }
        return n >= this._selectionStart && n <= this._selectionEnd;
    }

    protected abstract void writeMetadata(OutputStreamWriter var1, String var2, String var3) throws IOException;

    protected static void writeNameAndDescription(OutputStreamWriter outputStreamWriter, String string, String string2, String string3) throws IOException {
        if (!GpxWriter.isEmpty(string)) {
            outputStreamWriter.write(string3);
            outputStreamWriter.write("<name>");
            outputStreamWriter.write(string);
            outputStreamWriter.write("</name>\n");
        }
        outputStreamWriter.write(string3);
        outputStreamWriter.write("<desc>");
        outputStreamWriter.write(string2);
        outputStreamWriter.write("</desc>\n");
    }

    private static String getXmlHeaderString(OutputStreamWriter outputStreamWriter) {
        return "<?xml version=\"1.0\" encoding=\"" + XmlUtils.getEncoding(outputStreamWriter) + "\"?>\n";
    }

    private String getGpxHeaderString(FileInfo fileInfo) {
        String string = null;
        if (fileInfo != null) {
            string = this.getGpxHeader(fileInfo);
        }
        if (string == null || string.length() < 5) {
            string = this.getDefaultGpxHeader();
        }
        return String.valueOf(string) + "\n";
    }

    private int writeWaypoints(Writer writer, Track track) throws IOException {
        int n = track.getNumPoints();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint;
            if (this.shouldExportIndex(n3) && (dataPoint = track.getPoint(n3)).isWaypoint()) {
                if (this._progress != null) {
                    if (this._progress.wasCancelled()) {
                        return -1;
                    }
                    this._progress.setValue(n3);
                }
                this.exportWaypoint(dataPoint, writer);
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private void exportWaypoint(DataPoint dataPoint, Writer writer) throws IOException {
        String string;
        Object object;
        writer.write("\t<wpt lat=\"");
        writer.write(dataPoint.getLatitude().output(Coordinate.Format.DECIMAL_FORCE_POINT));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(Coordinate.Format.DECIMAL_FORCE_POINT));
        writer.write("\">\n");
        if (dataPoint.hasAltitude() || this._settings.getExportMissingAltitudesAsZero()) {
            writer.write("\t\t<ele>");
            writer.write(dataPoint.hasAltitude() ? dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES) : "0");
            writer.write("</ele>\n");
        }
        if (this._settings.getExportTimestamps() && (object = this.getPointTimestamp(dataPoint)) != null && ((Timestamp)object).isValid()) {
            writer.write("\t\t<time>");
            writer.write(this.getPointTimestamp(dataPoint).getText(Timestamp.Format.ISO8601, null));
            writer.write("</time>\n");
        }
        Object object2 = FieldGpx.getFirstFields();
        int n = ((FieldGpx[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            this.writeGpxTag(writer, "\t\t", dataPoint, (FieldGpx)object);
            ++n2;
        }
        writer.write("\t\t<name>");
        writer.write(XmlUtils.fixCdata(dataPoint.getWaypointName().trim()));
        writer.write("</name>\n");
        object = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.COMMENT));
        String string2 = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.DESCRIPTION));
        if (GpxWriter.isEmpty((String)object) && this._settings.getCopyDescriptionsToComments()) {
            object = string2;
        }
        if (!GpxWriter.isEmpty((String)object)) {
            writer.write("\t\t<cmt>");
            writer.write((String)object);
            writer.write("</cmt>\n");
        }
        if (!GpxWriter.isEmpty(string2)) {
            writer.write("\t\t<desc>");
            writer.write(string2);
            writer.write("</desc>\n");
        }
        if (this.versionSupportsPointLinks()) {
            if (this._settings.getExportPhotoPoints() && dataPoint.getPhoto() != null) {
                writer.write("\t\t");
                writer.write(this.makeMediaLink(dataPoint.getPhoto()));
                writer.write(10);
            }
            if (this._settings.getExportAudioPoints() && dataPoint.getAudio() != null) {
                writer.write("\t\t");
                writer.write(this.makeMediaLink(dataPoint.getAudio()));
                writer.write(10);
            }
        }
        if (!GpxWriter.isEmpty(string = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.SYMBOL)))) {
            writer.write("\t\t<sym>");
            writer.write(string);
            writer.write("</sym>\n");
        }
        if (!GpxWriter.isEmpty((String)(object2 = dataPoint.getFieldValue(Field.WAYPT_TYPE))) && !((String)(object2 = ((String)object2).trim())).equals("")) {
            writer.write("\t\t<type>");
            writer.write((String)object2);
            writer.write("</type>\n");
        }
        FieldGpx[] fieldGpxArray = FieldGpx.getSecondFields();
        int n3 = fieldGpxArray.length;
        int n4 = 0;
        while (n4 < n3) {
            FieldGpx fieldGpx = fieldGpxArray[n4];
            this.writeGpxTag(writer, "\t\t", dataPoint, fieldGpx);
            ++n4;
        }
        this.exportWaypointExtensions(dataPoint, writer);
        writer.write("\t</wpt>\n");
    }

    protected abstract boolean versionSupportsPointLinks();

    protected abstract void exportWaypointExtensions(DataPoint var1, Writer var2) throws IOException;

    protected abstract void exportTrackpointExtensions(DataPoint var1, Writer var2) throws IOException;

    private int writeTrackPoints(OutputStreamWriter outputStreamWriter, Track track, String string) throws IOException {
        int n = track.getNumPoints();
        int n2 = 0;
        boolean bl = this._settings.getExportTrackPoints();
        boolean bl2 = this._settings.getExportPhotoPoints();
        boolean bl3 = this._settings.getExportAudioPoints();
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint;
            if (this.shouldExportIndex(n3) && !(dataPoint = track.getPoint(n3)).isWaypoint()) {
                if (this._progress != null) {
                    this._progress.setValue(n3);
                }
                if (dataPoint.getPhoto() == null && bl || dataPoint.getPhoto() != null && bl2 || dataPoint.getAudio() != null && bl3) {
                    if (n2 > 0 && dataPoint.getSegmentStart()) {
                        outputStreamWriter.write("\t\t</trkseg>\n\t\t<trkseg>\n");
                    }
                    if (n2 == 0) {
                        String string2 = "\t<trk>\n\t\t<name>" + string + "</name>\n\t\t<number>1</number>\n\t\t<trkseg>\n";
                        outputStreamWriter.write(string2);
                    }
                    this.exportTrackpoint(dataPoint, outputStreamWriter);
                    ++n2;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            outputStreamWriter.write("\t\t</trkseg>\n\t</trk>\n");
        }
        return n2;
    }

    private void exportTrackpoint(DataPoint dataPoint, Writer writer) throws IOException {
        FieldGpx fieldGpx;
        Timestamp timestamp;
        writer.write("\t\t\t<trkpt lat=\"");
        writer.write(dataPoint.getLatitude().output(Coordinate.Format.DECIMAL_FORCE_POINT));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(Coordinate.Format.DECIMAL_FORCE_POINT));
        writer.write("\">\n");
        if (dataPoint.hasAltitude() || this._settings.getExportMissingAltitudesAsZero()) {
            writer.write("\t\t\t\t<ele>");
            writer.write(dataPoint.hasAltitude() ? dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES) : "0");
            writer.write("</ele>\n");
        }
        if ((timestamp = this.getPointTimestamp(dataPoint)) != null && this._settings.getExportTimestamps()) {
            writer.write("\t\t\t\t<time>");
            writer.write(timestamp.getText(Timestamp.Format.ISO8601, null));
            writer.write("</time>\n");
        }
        FieldGpx[] fieldGpxArray = FieldGpx.getFirstFields();
        int n = fieldGpxArray.length;
        int n2 = 0;
        while (n2 < n) {
            fieldGpx = fieldGpxArray[n2];
            this.writeGpxTag(writer, "\t\t\t\t", dataPoint, fieldGpx);
            ++n2;
        }
        fieldGpxArray = FieldGpx.getSecondFields();
        n = fieldGpxArray.length;
        n2 = 0;
        while (n2 < n) {
            fieldGpx = fieldGpxArray[n2];
            this.writeGpxTag(writer, "\t\t\t\t", dataPoint, fieldGpx);
            ++n2;
        }
        if (dataPoint.getPhoto() != null && this._settings.getExportPhotoPoints()) {
            writer.write("\t\t\t\t");
            writer.write(this.makeMediaLink(dataPoint.getPhoto()));
            writer.write("\n");
        }
        if (dataPoint.getAudio() != null && this._settings.getExportAudioPoints()) {
            writer.write(this.makeMediaLink(dataPoint.getAudio()));
        }
        this.exportTrackpointExtensions(dataPoint, writer);
        writer.write("\t\t\t</trkpt>\n");
    }

    private void writeGpxTag(Writer writer, String string, DataPoint dataPoint, FieldGpx fieldGpx) throws IOException {
        String string2 = dataPoint.getFieldValue(fieldGpx);
        if (string2 != null && this.versionSupportsTag(fieldGpx)) {
            writer.write(string);
            writer.write(fieldGpx.getOpenTag());
            writer.write(string2);
            writer.write(fieldGpx.getCloseTag());
            writer.write(10);
        }
    }

    protected abstract boolean versionSupportsTag(FieldGpx var1);

    private Timestamp getPointTimestamp(DataPoint dataPoint) {
        if (dataPoint.hasTimestamp()) {
            return dataPoint.getTimestamp();
        }
        if (dataPoint.getPhoto() != null && this._settings.getExportPhotoPoints() && dataPoint.getPhoto().hasTimestamp()) {
            return dataPoint.getPhoto().getTimestamp();
        }
        if (dataPoint.getAudio() != null && this._settings.getExportAudioPoints() && dataPoint.getAudio().hasTimestamp()) {
            return dataPoint.getAudio().getTimestamp();
        }
        return null;
    }

    protected static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    protected abstract String makeMediaLink(MediaObject var1);
}

