/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.RelativeDateFormatter;
import org.eclipse.jgit.util.SystemReader;

public class GitDateFormatter {
    private DateTimeFormatter dateTimeFormat;
    private DateTimeFormatter dateTimeFormat2;
    private final Format format;

    public GitDateFormatter(Format format) {
        this.format = format;
        switch (format) {
            default: {
                break;
            }
            case DEFAULT: {
                this.dateTimeFormat = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy Z", Locale.US);
                break;
            }
            case ISO: {
                this.dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.US);
                break;
            }
            case LOCAL: {
                this.dateTimeFormat = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy", Locale.US);
                break;
            }
            case RFC: {
                this.dateTimeFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
                break;
            }
            case SHORT: {
                this.dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.US);
                break;
            }
            case LOCALE: 
            case LOCALELOCAL: {
                this.dateTimeFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(Locale.US);
                this.dateTimeFormat2 = DateTimeFormatter.ofPattern("Z", Locale.US);
            }
        }
    }

    public String formatDate(PersonIdent ident) {
        switch (this.format) {
            case RAW: {
                int offset = ident.getZoneOffset().getTotalSeconds();
                String sign = offset < 0 ? "-" : "+";
                int offset2 = offset < 0 ? -offset : offset;
                int minutes = offset2 / 60 % 60;
                int hours = offset2 / 60 / 60;
                return String.format("%d %s%02d%02d", ident.getWhenAsInstant().getEpochSecond(), sign, hours, minutes);
            }
            case RELATIVE: {
                return RelativeDateFormatter.format(ident.getWhenAsInstant());
            }
            case LOCAL: 
            case LOCALELOCAL: {
                return this.dateTimeFormat.withZone(SystemReader.getInstance().getTimeZoneId()).format(ident.getWhenAsInstant());
            }
            case LOCALE: {
                ZoneId tz = ident.getZoneId();
                if (tz == null) {
                    tz = SystemReader.getInstance().getTimeZoneId();
                }
                return this.dateTimeFormat.withZone(tz).format(ident.getWhenAsInstant()) + " " + this.dateTimeFormat2.withZone(tz).format(ident.getWhenAsInstant());
            }
        }
        ZoneId tz = ident.getZoneId();
        if (tz == null) {
            tz = SystemReader.getInstance().getTimeZoneId();
        }
        return this.dateTimeFormat.withZone(tz).format(ident.getWhenAsInstant());
    }

    public static enum Format {
        DEFAULT,
        RELATIVE,
        LOCAL,
        ISO,
        RFC,
        SHORT,
        RAW,
        LOCALE,
        LOCALELOCAL;

    }
}

