/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.Project;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Project.class})
@NotThreadSafe
public class DeferredProjectConfiguration {
    private static final String TRACE = "org.gradle.trace.deferred.project.configuration";
    private final Project project;
    private final List<Runnable> configuration = new LinkedList<Runnable>();
    private boolean fired;
    private Throwable firedSentinel;

    public DeferredProjectConfiguration(Project project) {
        this.project = project;
    }

    public void add(Runnable configuration) {
        if (this.fired) {
            String message = "Cannot add deferred configuration for project " + this.project.getPath();
            if (this.firedSentinel == null) {
                throw new IllegalStateException(message);
            }
            throw new IllegalStateException(message, this.firedSentinel);
        }
        this.configuration.add(configuration);
    }

    public void fire() {
        if (!this.fired) {
            if (Boolean.getBoolean(TRACE)) {
                this.firedSentinel = new Exception("Project '" + this.project.getPath() + "' deferred configuration fired");
            }
            this.fired = true;
            try {
                for (Runnable runnable : this.configuration) {
                    runnable.run();
                }
            }
            finally {
                this.configuration.clear();
            }
        }
    }
}

