/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.publish.ivy.internal.artifact.AbstractIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationCoordinates;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class ArchiveTaskBasedIvyArtifact
extends AbstractIvyArtifact {
    private final AbstractArchiveTask archiveTask;
    private final IvyPublicationCoordinates coordinates;
    private final TaskDependencyInternal buildDependencies;

    public ArchiveTaskBasedIvyArtifact(AbstractArchiveTask archiveTask, IvyPublicationCoordinates coordinates, TaskDependencyFactory taskDependencyFactory) {
        super(taskDependencyFactory);
        this.archiveTask = archiveTask;
        this.coordinates = coordinates;
        this.buildDependencies = taskDependencyFactory.configurableDependency(ImmutableSet.of((Object)archiveTask));
    }

    @Override
    protected String getDefaultName() {
        return (String)this.coordinates.getModule().get();
    }

    @Override
    protected String getDefaultType() {
        return (String)this.archiveTask.getArchiveExtension().getOrNull();
    }

    @Override
    protected String getDefaultExtension() {
        return (String)this.archiveTask.getArchiveExtension().getOrNull();
    }

    @Override
    protected String getDefaultClassifier() {
        return (String)this.archiveTask.getArchiveClassifier().getOrNull();
    }

    @Override
    protected String getDefaultConf() {
        return null;
    }

    @Override
    protected TaskDependency getDefaultBuildDependencies() {
        return this.buildDependencies;
    }

    public File getFile() {
        return ((RegularFile)this.archiveTask.getArchiveFile().get()).getAsFile();
    }

    public boolean shouldBePublished() {
        return this.archiveTask.isEnabled();
    }
}

