/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestSuite;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.ListenerOrderDeterminer;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestResult;
import org.testng.internal.invokers.InvokedMethod;
import org.testng.junit.IJUnitTestRunner;
import org.testng.junit.JUnit3TestClass;
import org.testng.junit.JUnit3TestMethod;

@Deprecated
public class JUnitTestRunner
implements TestListener,
IJUnitTestRunner {
    public static final String SUITE_METHODNAME = "suite";
    private final ITestObjectFactory m_objectFactory;
    private final ITestResultNotifier m_parentRunner;
    private final Map<Test, TestRunInfo> m_tests = new WeakHashMap<Test, TestRunInfo>();
    private final List<ITestNGMethod> m_methods = Lists.newArrayList();
    private Collection<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();

    public JUnitTestRunner(ITestObjectFactory objectFactory, ITestResultNotifier tr) {
        this.m_objectFactory = objectFactory;
        this.m_parentRunner = tr;
    }

    @Override
    public List<ITestNGMethod> getTestMethods() {
        return this.m_methods;
    }

    public void startTest(Test test) {
        this.m_tests.put(test, new TestRunInfo(Calendar.getInstance().getTimeInMillis()));
    }

    public void addError(Test test, Throwable t) {
        this.recordFailure(test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.recordFailure(test, (Throwable)t);
    }

    private void recordFailure(Test test, Throwable t) {
        TestRunInfo tri = this.m_tests.get(test);
        if (null != tri) {
            tri.setThrowable(t);
        }
    }

    public void endTest(Test test) {
        TestRunInfo tri = this.m_tests.get(test);
        if (null == tri) {
            return;
        }
        TestResult tr = this.recordResults(test, tri);
        boolean isFinished = tr.getStatus() != 16;
        List<ITestListener> listeners = isFinished ? ListenerOrderDeterminer.reversedOrder(this.m_parentRunner.getTestListeners()) : ListenerOrderDeterminer.order(this.m_parentRunner.getTestListeners());
        TestListenerHelper.runTestListeners(tr, listeners);
    }

    @Override
    public void setInvokedMethodListeners(Collection<IInvokedMethodListener> listeners) {
        this.m_invokedMethodListeners = listeners;
    }

    private TestResult recordResults(Test test, TestRunInfo tri) {
        JUnit3TestClass tc = new JUnit3TestClass(test);
        JUnit3TestMethod tm = new JUnit3TestMethod(this.m_objectFactory, tc, test);
        ITestContext ctx = null;
        if (this.m_parentRunner instanceof ITestContext) {
            ctx = (ITestContext)((Object)this.m_parentRunner);
        }
        TestResult tr = TestResult.newEndTimeAwareTestResult(tm, ctx, tri.m_failure, tri.m_start);
        if (tri.isFailure()) {
            tr.setStatus(2);
            this.m_parentRunner.addFailedTest(tm, tr);
        } else {
            this.m_parentRunner.addPassedTest(tm, tr);
        }
        InvokedMethod im = new InvokedMethod(tri.m_start, tr);
        tm.setInvokedAt(im.getDate());
        this.m_methods.add(tm);
        for (IInvokedMethodListener l : this.m_invokedMethodListeners) {
            l.beforeInvocation(im, tr);
        }
        return tr;
    }

    protected Test getTest(Class<? extends Test> testClass, String ... methods) {
        if (methods.length > 0) {
            TestSuite ts = new TestSuite();
            try {
                Constructor<? extends Test> c = testClass.getConstructor(String.class);
                for (String m : methods) {
                    try {
                        ts.addTest(this.m_objectFactory.newInstance(c, m));
                    }
                    catch (TestNGException ex) {
                        this.runFailed(testClass, ex.getMessage());
                    }
                    catch (IllegalArgumentException ex) {
                        this.runFailed(testClass, "actual and formal parameters differ " + ex);
                    }
                }
            }
            catch (NoSuchMethodException ex) {
                this.runFailed(testClass, "no constructor accepting String argument found " + ex);
            }
            catch (SecurityException ex) {
                this.runFailed(testClass, "security exception " + ex);
            }
            return ts;
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception e) {
            return new TestSuite(testClass);
        }
        if (!Modifier.isStatic(suiteMethod.getModifiers())) {
            this.runFailed(testClass, "suite() method must be static");
            return null;
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException e) {
            this.runFailed(testClass, "failed to invoke method suite():" + e.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.runFailed(testClass, "failed to invoke method suite():" + e.toString());
            return null;
        }
        return test;
    }

    public void run(Class testClass, String ... methods) {
        this.start(testClass, methods);
    }

    public junit.framework.TestResult start(Class testCase, String ... methods) {
        try {
            Test suite = this.getTest(testCase, methods);
            if (null != suite) {
                return this.doRun(suite);
            }
            this.runFailed(testCase, "could not create/run JUnit test suite");
        }
        catch (Exception e) {
            this.runFailed(testCase, "could not create/run JUnit test suite: " + e.getMessage());
        }
        return null;
    }

    protected void runFailed(Class clazz, String message) {
        throw new TestNGException("Failure in JUnit mode for class " + clazz.getName() + ": " + message);
    }

    protected junit.framework.TestResult createTestResult() {
        return new junit.framework.TestResult();
    }

    protected junit.framework.TestResult doRun(Test suite) {
        junit.framework.TestResult result = this.createTestResult();
        result.addListener((TestListener)this);
        suite.run(result);
        return result;
    }

    private static class TestRunInfo {
        private final long m_start;
        private Throwable m_failure;

        public TestRunInfo(long start) {
            this.m_start = start;
        }

        public boolean isFailure() {
            return null != this.m_failure;
        }

        public void setThrowable(Throwable t) {
            this.m_failure = t;
        }
    }
}

