/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.tracing.Tracer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.OutboundSemiGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildRootIndexImpl;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.TargetOutputIndexImpl;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.model.module.JpsModule;

@ApiStatus.Internal
public final class BuildTargetIndexImpl
implements BuildTargetIndex {
    private final BuildTargetRegistry myRegistry;
    private final BuildRootIndexImpl myBuildRootIndex;
    private final Map<BuildTarget<?>, Collection<BuildTarget<?>>> myDependencies;
    private List<BuildTargetChunk> myTargetChunks;

    public BuildTargetIndexImpl(@NotNull BuildTargetRegistry targetRegistry, @NotNull BuildRootIndexImpl buildRootIndex) {
        if (targetRegistry == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(0);
        }
        if (buildRootIndex == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(1);
        }
        this.myRegistry = targetRegistry;
        this.myBuildRootIndex = buildRootIndex;
        this.myDependencies = new HashMap();
    }

    @Override
    @NotNull
    public List<BuildTargetChunk> getSortedTargetChunks(@NotNull CompileContext context) {
        if (context == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(2);
        }
        this.initializeChunks(context);
        List<BuildTargetChunk> list = this.myTargetChunks;
        if (list == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    private synchronized void initializeChunks(@NotNull CompileContext context) {
        if (context == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(4);
        }
        if (this.myTargetChunks != null) {
            return;
        }
        Tracer.Span chunksInitSpan = Tracer.start((String)"BuildTargetIndexImpl.initializeChunks");
        final List<BuildTarget<?>> allTargets = this.getAllTargets();
        TargetOutputIndexImpl outputIndex = new TargetOutputIndexImpl(allTargets, context);
        HashMap dummyTargetDependencies = new HashMap();
        ArrayList realTargets = new ArrayList(allTargets.size());
        for (BuildTarget<Object> target : allTargets) {
            if (this.isDummy(target)) {
                dummyTargetDependencies.put(target, target.computeDependencies(this.myRegistry, outputIndex));
                continue;
            }
            realTargets.add(target);
        }
        for (BuildTarget<Object> target : realTargets) {
            Collection<BuildTarget<?>> dependencies = target.computeDependencies(this, outputIndex);
            Collection<BuildTarget<?>> realDependencies = !ContainerUtil.intersects(dependencies, dummyTargetDependencies.keySet()) ? dependencies : BuildTargetIndexImpl.includeTransitiveDependenciesOfDummyTargets(dependencies, dummyTargetDependencies);
            this.myDependencies.put(target, realDependencies);
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<BuildTarget<?>>(){

            @NotNull
            public Collection<BuildTarget<?>> getNodes() {
                List list = allTargets;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public Iterator<BuildTarget<?>> getIn(BuildTarget<?> n) {
                Collection<BuildTarget<?>> deps = BuildTargetIndexImpl.this.myDependencies.get(n);
                Iterator<Object> iterator = deps != null ? deps.iterator() : Collections.emptyIterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        DFSTBuilder builder = new DFSTBuilder((OutboundSemiGraph)graph);
        Collection components = builder.getComponents();
        this.myTargetChunks = new ArrayList<BuildTargetChunk>(components.size());
        for (Collection component : components) {
            this.myTargetChunks.add(new BuildTargetChunk(new LinkedHashSet(component)));
        }
        chunksInitSpan.complete();
    }

    private static Collection<BuildTarget<?>> includeTransitiveDependenciesOfDummyTargets(Collection<? extends BuildTarget<?>> dependencies, Map<BuildTarget<?>, Collection<BuildTarget<?>>> dummyTargetDependencies) {
        ArrayList realDependencies = new ArrayList(dependencies.size());
        HashSet processed = new HashSet(dependencies);
        ArrayDeque toProcess = new ArrayDeque(dependencies);
        while (!toProcess.isEmpty()) {
            BuildTarget dep = (BuildTarget)toProcess.poll();
            Collection<BuildTarget<?>> toInclude = dummyTargetDependencies.get(dep);
            if (toInclude != null) {
                for (BuildTarget<?> target : toInclude) {
                    if (!processed.add(target)) continue;
                    toProcess.add(target);
                }
            }
            realDependencies.add(dep);
        }
        realDependencies.trimToSize();
        return realDependencies;
    }

    @Override
    public boolean isDummy(@NotNull BuildTarget<?> target) {
        if (target == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(5);
        }
        return target.getTargetType().isFileBased() && this.myBuildRootIndex.getTargetRoots(target, null).isEmpty();
    }

    @Override
    public Set<BuildTarget<?>> getDependenciesRecursively(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        if (target == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(6);
        }
        if (context == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(7);
        }
        this.initializeChunks(context);
        LinkedHashSet result = new LinkedHashSet();
        for (BuildTarget<?> dep : this.getDependencies(target, context)) {
            this.collectDependenciesRecursively(dep, result, context);
        }
        return result;
    }

    private void collectDependenciesRecursively(BuildTarget<?> target, LinkedHashSet<? super BuildTarget<?>> result, CompileContext context) {
        if (result.add(target)) {
            for (BuildTarget<?> dep : this.getDependencies(target, context)) {
                this.collectDependenciesRecursively(dep, result, context);
            }
        }
    }

    @Override
    @NotNull
    public Collection<BuildTarget<?>> getDependencies(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        if (target == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(8);
        }
        if (context == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(9);
        }
        this.initializeChunks(context);
        Collection<BuildTarget<?>> deps = this.myDependencies.get(target);
        Collection<BuildTarget<Object>> collection = deps != null ? deps : Collections.emptyList();
        if (collection == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<ModuleBasedTarget<?>> getModuleBasedTargets(@NotNull JpsModule module, @NotNull BuildTargetRegistry.ModuleTargetSelector selector) {
        if (module == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(11);
        }
        if (selector == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(12);
        }
        Collection<ModuleBasedTarget<?>> collection = this.myRegistry.getModuleBasedTargets(module, selector);
        if (collection == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Override
    @NotNull
    public <T extends BuildTarget<?>> List<T> getAllTargets(@NotNull BuildTargetType<T> type) {
        if (type == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(14);
        }
        List<T> list = this.myRegistry.getAllTargets(type);
        if (list == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @NotNull
    public List<BuildTarget<?>> getAllTargets() {
        List<BuildTarget<?>> list = this.myRegistry.getAllTargets();
        if (list == null) {
            BuildTargetIndexImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildRootIndex";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedTargetChunks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleBasedTargets";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSortedTargetChunks";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initializeChunks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDummy";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesRecursively";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleBasedTargets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

