/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.debugger.GroovyDebuggerSettings;

final class GroovyHotSwapper
extends JavaProgramPatcher {
    private static final Logger LOG = Logger.getInstance(GroovyHotSwapper.class);
    private static final String GROOVY_HOTSWAP_AGENT_PATH = "groovy.hotswap.agent.path";
    private static final Pattern SPRING_LOADED_PATTERN = Pattern.compile("-javaagent:.+springloaded-[^/\\\\]+\\.jar");

    GroovyHotSwapper() {
    }

    private static boolean containsGroovyClasses(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)FileTypeIndex.containsFileOfType((FileType)GroovyFileType.GROOVY_FILE_TYPE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean hasSpringLoadedReloader(JavaParameters javaParameters) {
        for (String param : javaParameters.getVMParametersList().getParameters()) {
            if (!SPRING_LOADED_PATTERN.matcher(param).matches()) continue;
            return true;
        }
        return false;
    }

    public void patchJavaParameters(Executor executor, RunProfile configuration, JavaParameters javaParameters) {
        String agentPath;
        JdkVersionDetector.JdkVersionInfo info;
        JavaSdkVersion version;
        LanguageLevel level;
        Module module;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!executor.getId().equals("Debug")) {
            return;
        }
        if (!GroovyDebuggerSettings.getInstance().ENABLE_GROOVY_HOTSWAP) {
            return;
        }
        if (GroovyHotSwapper.hasSpringLoadedReloader(javaParameters)) {
            return;
        }
        if (!(configuration instanceof RunConfiguration)) {
            return;
        }
        Project project = ((RunConfiguration)configuration).getProject();
        if (project == null) {
            return;
        }
        if (!LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return;
        }
        if (configuration instanceof ModuleBasedConfiguration && (module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null && !(level = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module)).isAtLeast(LanguageLevel.JDK_1_5)) {
            return;
        }
        Sdk jdk = javaParameters.getJdk();
        if (jdk != null && (version = JavaSdk.getInstance().getVersion(jdk)) != null && !version.isAtLeast(JavaSdkVersion.JDK_1_8) && jdk.getHomePath() != null && (info = JdkVersionDetector.getInstance().detectJdkVersionInfo(jdk.getHomePath())) != null && info.variant == JdkVersionDetector.Variant.IBM) {
            LOG.info("Due to old IBM JDK peculiarities (IDEA-59070) we don't add Groovy agent when running applications under it");
            return;
        }
        if (!project.isDefault() && GroovyHotSwapper.containsGroovyClasses(project) && (agentPath = JavaExecutionUtil.handleSpacesInAgentPath((String)GroovyHotSwapper.getAgentJarPath(), (String)"groovyHotSwap", (String)GROOVY_HOTSWAP_AGENT_PATH)) != null) {
            javaParameters.getVMParametersList().add("-javaagent:" + agentPath);
        }
    }

    private static String getAgentJarPath() {
        File ourJar = new File(PathUtil.getJarPathForClass(GroovyHotSwapper.class));
        if (ourJar.isDirectory()) {
            return PluginPathManager.getPluginHomePath((String)"groovy") + "/hotswap/gragent.jar";
        }
        String relevantJarsRoot = PathManager.getArchivedCompliedClassesLocation();
        if (relevantJarsRoot != null && ourJar.toPath().startsWith(relevantJarsRoot)) {
            return PluginPathManager.getPluginHomePath((String)"groovy") + "/hotswap/gragent.jar";
        }
        File pluginDir = ourJar.getParentFile();
        return pluginDir.getPath() + File.separator + "agent" + File.separator + "gragent.jar";
    }
}

