/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ComparisonPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;

public final class FlipComparisonIntention
extends GrPsiUpdateIntention {
    @Override
    @NotNull
    public String getText(@NotNull PsiElement element) {
        String flippedComparison;
        GrBinaryExpression binaryExpression;
        IElementType tokenType;
        String comparison;
        if (element == null) {
            FlipComparisonIntention.$$$reportNull$$$0(0);
        }
        if ((comparison = ComparisonUtils.getStringForComparison(tokenType = (binaryExpression = (GrBinaryExpression)element).getOperationTokenType())).equals(flippedComparison = ComparisonUtils.getFlippedComparison(tokenType))) {
            String string = GroovyIntentionsBundle.message("flip.smth.intention.name", comparison);
            if (string == null) {
                FlipComparisonIntention.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = GroovyIntentionsBundle.message("flip.comparison.intention.name", comparison, flippedComparison);
        if (string == null) {
            FlipComparisonIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            FlipComparisonIntention.$$$reportNull$$$0(3);
        }
        if (context == null) {
            FlipComparisonIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            FlipComparisonIntention.$$$reportNull$$$0(5);
        }
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = lhs.getText();
        GrExpression rhs = exp.getRightOperand();
        String rhsText = rhs.getText();
        String flippedComparison = ComparisonUtils.getFlippedComparison(tokenType);
        String newExpression = rhsText + flippedComparison + lhsText;
        PsiImplUtil.replaceExpression(newExpression, exp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/FlipComparisonIntention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/FlipComparisonIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

