/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ClassNameDiffersFromFileNamePredicate;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public final class MoveClassToNewFileIntention
extends Intention {
    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            MoveClassToNewFileIntention.$$$reportNull$$$0(0);
        }
        return currentFile;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            MoveClassToNewFileIntention.$$$reportNull$$$0(1);
        }
        if (project == null) {
            MoveClassToNewFileIntention.$$$reportNull$$$0(2);
        }
        GrTypeDefinition psiClass = (GrTypeDefinition)element.getParent();
        String name = psiClass.getName();
        PsiFile file = psiClass.getContainingFile();
        String fileExtension = FileUtilRt.getExtension((String)file.getName());
        String newFileName = name + "." + fileExtension;
        PsiDirectory dir = file.getParent();
        if (dir != null && dir.findFile(newFileName) != null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                String message = GroovyBundle.message("file.exists", newFileName, dir.getName());
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getFamilyName(), null);
            }
            return;
        }
        GroovyFile newFile = (GroovyFile)GroovyTemplatesFactory.createFromTemplate(dir, name, newFileName, "Groovy Class.groovy", true, new String[0]);
        WriteAction.run(() -> {
            GrTypeDefinition template = newFile.getTypeDefinitions()[0];
            PsiElement newClass = template.replace(psiClass);
            GrDocComment docComment = psiClass.getDocComment();
            if (newClass instanceof GrTypeDefinition && docComment != null) {
                GrDocComment newDoc = ((GrTypeDefinition)newClass).getDocComment();
                if (newDoc != null) {
                    newDoc.replace(docComment);
                } else {
                    PsiElement parent = newClass.getParent();
                    parent.addBefore((PsiElement)docComment, (PsiElement)psiClass);
                    parent.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", psiClass.getNode());
                }
                docComment.delete();
            }
            psiClass.delete();
            IntentionUtils.positionCursor(project, newClass.getContainingFile(), newClass.getNavigationElement());
        });
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ClassNameDiffersFromFileNamePredicate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/MoveClassToNewFileIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToMakeWritable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

