/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import java.util.Arrays;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class TestUniqueId
extends TestObject {
    public TestUniqueId(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        ReadAction.run(() -> this.addClassesListToJavaParameters(Arrays.asList(data.getUniqueIds()), TestUniqueId.getUniqueIdPresentation(), "", true, javaParameters));
        return javaParameters;
    }

    public static Function<String, String> getUniqueIdPresentation() {
        return s -> "\u001b" + s;
    }

    public static String getEffectiveNodeId(AbstractTestProxy testInfo, Project project, GlobalSearchScope searchScope) {
        String nodeId = (String)testInfo.getUserData(SMTestProxy.NODE_ID);
        if (nodeId != null) {
            Location parentLocation;
            AbstractTestProxy parent;
            Location location = testInfo.getLocation(project, searchScope);
            if (location == null) {
                return nodeId;
            }
            PsiElement psiElement = location.getPsiElement();
            UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)psiElement, UMethod.class);
            if (uMethod != null) {
                TestFramework testFramework;
                containingClass = uMethod.getContainingClass();
                TestFramework testFramework2 = testFramework = containingClass != null ? TestFrameworks.detectFramework((PsiClass)containingClass) : null;
                if (testFramework == null || !testFramework.isTestMethod(psiElement)) {
                    return nodeId;
                }
            } else {
                containingClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)psiElement, UClass.class);
                if (containingClass == null || TestFrameworks.detectFramework((PsiClass)containingClass) == null || UastContextKt.getUastParentOfType((PsiElement)psiElement, UField.class) != null) {
                    return nodeId;
                }
            }
            if ((parent = testInfo.getParent()) != null && (parentLocation = parent.getLocation(project, searchScope)) != null && parentLocation.getPsiElement() == psiElement) {
                return nodeId;
            }
        }
        return null;
    }

    @Override
    public String suggestActionName() {
        return ProgramRunnerUtil.shortenName((String)this.getConfiguration().getName(), (int)2);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element) {
        return null;
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return false;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String[] ids = this.getConfiguration().getPersistentData().getUniqueIds();
        if (ids == null || ids.length == 0) {
            throw new RuntimeConfigurationException(JUnitBundle.message("dialog.message.no.unique.id.specified.exception", new Object[0]));
        }
    }
}

