/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u00016B-\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJJ\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0\u001a2\u0014\u0010\u001d\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020 0\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J@\u0010#\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0$2\u0006\u0010!\u001a\u00020\"2\u001c\u0010\u001d\u001a\u0018\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00180%H\u0007J \u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020'2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u001eH\u0015J \u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u001bj\u0002`\u001c0\u001aH$J!\u0010*\u001a\u00020\u00182\n\u0010+\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010,\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020/H\u0014J6\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\t2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u001eH%J\b\u00105\u001a\u00020\u0018H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lcom/intellij/vcs/log/data/AbstractDataGetter;", "T", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/vcs/log/data/DataGetter;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "parentDisposable", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;Lcom/intellij/openapi/Disposable;)V", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "getLogProviders", "()Ljava/util/Map;", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "getDisposableFlag", "()Lcom/intellij/openapi/util/CheckedDisposable;", "loadCommitsData", "", "commits", "", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "consumer", "Lcom/intellij/util/Consumer;", "errorConsumer", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadCommitsDataSynchronously", "", "Lkotlin/Function2;", "doLoadCommitsData", "Lit/unimi/dsi/fastutil/ints/IntSet;", "getCachedData", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "saveInCache", "commit", "details", "(ILcom/intellij/vcs/log/VcsShortCommitDetails;)V", "cacheCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "doLoadCommitsDataFromProvider", "logProvider", "root", "hashes", "", "notifyLoaded", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nAbstractDataGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,175:1\n1#2:176\n1#2:201\n1504#3:177\n1534#3,3:178\n1537#3,3:188\n1617#3,9:191\n1869#3:200\n1870#3:202\n1626#3:203\n382#4,7:181\n*S KotlinDebug\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter\n*L\n38#1:201\n105#1:177\n105#1:178,3\n105#1:188,3\n38#1:191,9\n38#1:200\n38#1:202\n38#1:203\n105#1:181,7\n*E\n"})
public abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private static final Logger LOG;

    public AbstractDataGetter(@NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.storage = storage;
        this.logProviders = logProviders;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposableFlag = checkedDisposable;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
    }

    @NotNull
    protected final VcsLogStorage getStorage() {
        return this.storage;
    }

    @NotNull
    protected final Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.logProviders;
    }

    @NotNull
    protected final CheckedDisposable getDisposableFlag() {
        return this.disposableFlag;
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> commits, @NotNull Consumer<? super List<? extends T>> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator) {
        IntOpenHashSet intOpenHashSet;
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(errorConsumer, (String)"errorConsumer");
        Int2ObjectMap<T> detailsFromCache = this.getCachedData(commits);
        if (detailsFromCache.size() == commits.size()) {
            AbstractDataGetter.Companion.runInCurrentThread(indicator, (Function0<Unit>)() -> AbstractDataGetter.loadCommitsData$lambda$1(consumer, commits, detailsFromCache));
            return;
        }
        IntOpenHashSet $this$loadCommitsData_u24lambda_u242 = intOpenHashSet = new IntOpenHashSet((Collection)commits);
        boolean bl = false;
        $this$loadCommitsData_u24lambda_u242.removeAll((IntCollection)detailsFromCache.keySet());
        IntOpenHashSet toLoad = intOpenHashSet;
        this.cacheCommits(toLoad);
        String string = VcsLogBundle.message("vcs.log.loading.selected.details.process", new Object[0]);
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        Task.Backgroundable task2 = new Task.Backgroundable(this, toLoad, commits, detailsFromCache, consumer, errorConsumer, string, performInBackgroundOption){
            final /* synthetic */ AbstractDataGetter<T> this$0;
            final /* synthetic */ IntOpenHashSet $toLoad;
            final /* synthetic */ List<Integer> $commits;
            final /* synthetic */ Int2ObjectMap<T> $detailsFromCache;
            final /* synthetic */ Consumer<? super List<? extends T>> $consumer;
            final /* synthetic */ Consumer<? super Throwable> $errorConsumer;
            {
                this.this$0 = $receiver;
                this.$toLoad = $toLoad;
                this.$commits = $commits;
                this.$detailsFromCache = $detailsFromCache;
                this.$consumer = $consumer;
                this.$errorConsumer = $errorConsumer;
                super(null, $super_call_param$1, true, $super_call_param$2);
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.checkCanceled();
                try {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Int2ObjectOpenHashMap detailsFromProvider = new Int2ObjectOpenHashMap();
                    this.this$0.doLoadCommitsData((IntSet)this.$toLoad, arg_0 -> loadCommitsData.task.1.run$lambda$1(arg_0 -> loadCommitsData.task.1.run$lambda$0(this.this$0, detailsFromProvider, arg_0), arg_0));
                    Iterable iterable = this.$commits;
                    Int2ObjectMap<T> int2ObjectMap = this.$detailsFromCache;
                    boolean $i$f$mapNotNull = false;
                    void var7_8 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        int it = ((Number)element$iv$iv).intValue();
                        boolean bl2 = false;
                        VcsShortCommitDetails vcsShortCommitDetails = (VcsShortCommitDetails)int2ObjectMap.get(it);
                        if (vcsShortCommitDetails == null) {
                            vcsShortCommitDetails = (VcsShortCommitDetails)detailsFromProvider.get(it);
                        }
                        if (vcsShortCommitDetails == null) continue;
                        VcsShortCommitDetails it$iv$iv = vcsShortCommitDetails;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List result = (List)destination$iv$iv;
                    BaseSingleTaskControllerKt.runInEdt(this.this$0.getDisposableFlag(), (Function0<Unit>)((Function0)() -> loadCommitsData.task.1.run$lambda$3(this.this$0, this.$consumer, result)));
                }
                catch (ProcessCanceledException detailsFromProvider) {
                }
                catch (Throwable t) {
                    if (!(t instanceof VcsException)) {
                        AbstractDataGetter.access$getLOG$cp().error(t);
                    }
                    BaseSingleTaskControllerKt.runInEdt(this.this$0.getDisposableFlag(), (Function0<Unit>)((Function0)() -> loadCommitsData.task.1.run$lambda$4(this.$errorConsumer, t)));
                }
            }

            private static final Unit run$lambda$0(AbstractDataGetter this$0, Int2ObjectOpenHashMap $detailsFromProvider, VcsShortCommitDetails metadata) {
                VcsLogStorage vcsLogStorage = this$0.getStorage();
                Object object = ((TimedVcsCommit)metadata).getId();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
                Hash hash = (Hash)object;
                VirtualFile virtualFile = metadata.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                int commitIndex = vcsLogStorage.getCommitIndex(hash, virtualFile);
                Intrinsics.checkNotNull((Object)metadata);
                this$0.saveInCache(commitIndex, metadata);
                ((Map)$detailsFromProvider).put(commitIndex, metadata);
                return Unit.INSTANCE;
            }

            private static final void run$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final Unit run$lambda$3(AbstractDataGetter this$0, Consumer $consumer, List $result) {
                this$0.notifyLoaded();
                $consumer.consume((Object)$result);
                return Unit.INSTANCE;
            }

            private static final Unit run$lambda$4(Consumer $errorConsumer, Throwable $t) {
                $errorConsumer.consume((Object)$t);
                return Unit.INSTANCE;
            }
        };
        AbstractDataGetter.Companion.runInBackgroundThread(indicator, task2);
    }

    @RequiresBackgroundThread
    public final void loadCommitsDataSynchronously(@NotNull Iterable<Integer> commits, @NotNull ProgressIndicator indicator, @NotNull Function2<? super Integer, ? super T, Unit> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        IntOpenHashSet toLoad = new IntOpenHashSet();
        Iterator<Integer> iterator = commits.iterator();
        while (iterator.hasNext()) {
            int id = ((Number)iterator.next()).intValue();
            VcsShortCommitDetails details = this.getCachedData(id);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id);
                continue;
            }
            consumer.invoke((Object)id, (Object)details);
        }
        if (!toLoad.isEmpty()) {
            indicator.checkCanceled();
            this.doLoadCommitsData((IntSet)toLoad, arg_0 -> AbstractDataGetter.loadCommitsDataSynchronously$lambda$4(arg_0 -> AbstractDataGetter.loadCommitsDataSynchronously$lambda$3(this, consumer, arg_0), arg_0));
            this.notifyLoaded();
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    protected void doLoadCommitsData(@NotNull IntSet commits, @NotNull Consumer<? super T> consumer) throws VcsException {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)commits, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable iterable = this.storage.getCommitIds((Collection)commits).values();
        boolean bl = false;
        void var6_6 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            VirtualFile key$iv$iv;
            CommitId it2 = (CommitId)element$iv$iv;
            boolean $i$a$-groupBy-AbstractDataGetter$doLoadCommitsData$hashesGroupedByRoot$332 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getRoot(), (String)"getRoot(...)");
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            CommitId $i$a$-groupBy-AbstractDataGetter$doLoadCommitsData$hashesGroupedByRoot$332 = (CommitId)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            String string = it.getHash().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            list.add(string);
        }
        Map hashesGroupedByRoot = destination$iv$iv;
        for (Map.Entry entry : hashesGroupedByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            List hashes = (List)entry.getValue();
            VcsLogProvider logProvider = this.logProviders.get(root);
            if (logProvider == null) {
                LOG.error("No log provider for root " + root.getPath() + ". All known log providers " + this.logProviders);
                continue;
            }
            this.doLoadCommitsDataFromProvider(logProvider, root, hashes, consumer);
        }
    }

    @NotNull
    protected abstract Int2ObjectMap<T> getCachedData(@NotNull List<Integer> var1);

    protected abstract void saveInCache(int var1, @NotNull T var2);

    protected void cacheCommits(@NotNull IntOpenHashSet commits) {
        Intrinsics.checkNotNullParameter((Object)commits, (String)"commits");
    }

    @RequiresBackgroundThread
    protected abstract void doLoadCommitsDataFromProvider(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3, @NotNull Consumer<? super T> var4) throws VcsException;

    protected void notifyLoaded() {
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit loadCommitsData$lambda$1(Consumer $consumer, List $commits, Int2ObjectMap $detailsFromCache) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = $commits;
        Consumer consumer = $consumer;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VcsShortCommitDetails it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if ((VcsShortCommitDetails)$detailsFromCache.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        consumer.consume((Object)((List)destination$iv$iv));
        return Unit.INSTANCE;
    }

    private static final Unit loadCommitsDataSynchronously$lambda$3(AbstractDataGetter this$0, Function2 $consumer, VcsShortCommitDetails details) {
        VcsLogStorage vcsLogStorage = this$0.storage;
        Object object = ((TimedVcsCommit)details).getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
        Hash hash = (Hash)object;
        VirtualFile virtualFile = details.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        int commitIndex = vcsLogStorage.getCommitIndex(hash, virtualFile);
        Intrinsics.checkNotNull((Object)details);
        this$0.saveInCache(commitIndex, details);
        $consumer.invoke((Object)commitIndex, (Object)details);
        return Unit.INSTANCE;
    }

    private static final void loadCommitsDataSynchronously$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static final <T extends VcsShortCommitDetails> List<T> getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull List<Integer> commits) throws VcsException {
        return Companion.getCommitDetails($this$getCommitDetails, commits);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static final <T extends VcsShortCommitDetails> T getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull Hash hash, @NotNull VirtualFile root) throws VcsException {
        return Companion.getCommitDetails($this$getCommitDetails, hash, root);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(AbstractDataGetter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\u001a\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\b\b\u0001\u0010\u0012*\u00020\u0013*\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0016j\u0002`\u00170\u0011H\u0007J1\u0010\u0010\u001a\u0002H\u0012\"\b\b\u0001\u0010\u0012*\u00020\u0013*\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/data/AbstractDataGetter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "runInCurrentThread", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runnable", "Lkotlin/Function0;", "runInBackgroundThread", "task", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "getCommitDetails", "", "T", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "Lcom/intellij/vcs/log/data/AbstractDataGetter;", "commits", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/vcs/log/data/AbstractDataGetter;Lcom/intellij/vcs/log/Hash;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/vcs/log/VcsShortCommitDetails;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nAbstractDataGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1617#2,9:176\n1869#2:185\n1870#2:187\n1626#2:188\n1#3:186\n*S KotlinDebug\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter$Companion\n*L\n162#1:176,9\n162#1:185\n162#1:187\n162#1:188\n162#1:186\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void runInCurrentThread(ProgressIndicator indicator, Function0<Unit> runnable) {
            if (indicator != null) {
                ProgressManager.getInstance().runProcess(() -> Companion.runInCurrentThread$lambda$0(runnable), indicator);
            } else {
                runnable.invoke();
            }
        }

        private final void runInBackgroundThread(ProgressIndicator indicator, Task.Backgroundable task2) {
            if (indicator != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator);
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @RequiresBackgroundThread
        @NotNull
        public final <T extends VcsShortCommitDetails> List<T> getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull List<Integer> commits) throws VcsException {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$getCommitDetails, (String)"<this>");
            Intrinsics.checkNotNullParameter(commits, (String)"commits");
            Int2ObjectOpenHashMap commitToDetailsMap = new Int2ObjectOpenHashMap();
            Iterable iterable = commits;
            ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
            if (progressIndicator == null) {
                progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            }
            $this$getCommitDetails.loadCommitsDataSynchronously(iterable, progressIndicator, (arg_0, arg_1) -> Companion.getCommitDetails$lambda$1(commitToDetailsMap, arg_0, arg_1));
            Iterable $this$mapNotNull$iv = commits;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VcsShortCommitDetails it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if ((VcsShortCommitDetails)commitToDetailsMap.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @RequiresBackgroundThread
        @NotNull
        public final <T extends VcsShortCommitDetails> T getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull Hash hash, @NotNull VirtualFile root) throws VcsException {
            Intrinsics.checkNotNullParameter($this$getCommitDetails, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            List<T> commitDetailsList = this.getCommitDetails($this$getCommitDetails, CollectionsKt.listOf((Object)$this$getCommitDetails.getStorage().getCommitIndex(hash, root)));
            VcsShortCommitDetails vcsShortCommitDetails = (VcsShortCommitDetails)CollectionsKt.singleOrNull(commitDetailsList);
            if (vcsShortCommitDetails == null) {
                Object[] objectArray = new Object[]{hash.asString(), root.getName()};
                throw new VcsException(VcsLogBundle.message("vcs.log.failed.loading.details", objectArray));
            }
            return (T)vcsShortCommitDetails;
        }

        private static final void runInCurrentThread$lambda$0(Function0 $tmp0) {
            $tmp0.invoke();
        }

        private static final Unit getCommitDetails$lambda$1(Int2ObjectOpenHashMap $commitToDetailsMap, int commitIndex, VcsShortCommitDetails details) {
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            ((Map)$commitToDetailsMap).put(commitIndex, details);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

