/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.contracts.parsing.PsiConditionParser;
import org.jetbrains.kotlin.contracts.parsing.PsiConstantParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.PsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiCallsEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiConditionalEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiReturnsEffectParser;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J$\u0010\u001a\u001a\u00020\u001b2\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u00170\u001e0\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0012\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0012\u0010%\u001a\u0004\u0018\u00010&2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "conditionParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "constantParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConstantParser;", "effectsParsers", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/contracts/parsing/PsiEffectParser;", "parseContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "parseCondition", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "parseEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "checkDuplicatedCallsEffectsAndReport", "", "effects", "", "Lkotlin/Pair;", "isValidEffectDeclaration", "", "parseConstant", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "parseVariable", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "parseValue", "Lorg/jetbrains/kotlin/contracts/description/expressions/ContractDescriptionValue;", "frontend"})
@SourceDebugExtension(value={"SMAP\nPsiContractParserDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiContractParserDispatcher.kt\norg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1563#2:163\n1634#2,3:164\n1617#2,9:167\n1869#2:176\n1870#2:178\n1626#2:179\n1#3:177\n*S KotlinDebug\n*F\n+ 1 PsiContractParserDispatcher.kt\norg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher\n*L\n70#1:163\n70#1:164,3\n72#1:167,9\n72#1:176\n72#1:178\n72#1:179\n72#1:177\n*E\n"})
public final class PsiContractParserDispatcher {
    @NotNull
    private final ContractParsingDiagnosticsCollector collector;
    @NotNull
    private final ContractCallContext callContext;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final PsiConditionParser conditionParser;
    @NotNull
    private final PsiConstantParser constantParser;
    @NotNull
    private final Map<Name, PsiEffectParser> effectsParsers;

    public PsiContractParserDispatcher(@NotNull ContractParsingDiagnosticsCollector collector2, @NotNull ContractCallContext callContext, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.collector = collector2;
        this.callContext = callContext;
        this.storageManager = storageManager;
        this.conditionParser = new PsiConditionParser(this.collector, this.callContext, this);
        this.constantParser = new PsiConstantParser(this.callContext);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ContractsDslNames.INSTANCE.getRETURNS_EFFECT(), (Object)new PsiReturnsEffectParser(this.collector, this.callContext, this)), TuplesKt.to((Object)ContractsDslNames.INSTANCE.getRETURNS_NOT_NULL_EFFECT(), (Object)new PsiReturnsEffectParser(this.collector, this.callContext, this)), TuplesKt.to((Object)ContractsDslNames.INSTANCE.getCALLS_IN_PLACE_EFFECT(), (Object)new PsiCallsEffectParser(this.collector, this.callContext, this)), TuplesKt.to((Object)ContractsDslNames.INSTANCE.getCONDITIONAL_EFFECT(), (Object)new PsiConditionalEffectParser(this.collector, this.callContext, this))};
        this.effectsParsers = MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ContractDescription parseContract() {
        void $this$mapNotNullTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)this.callContext.getContractCallExpression(), this.callContext.getBindingContext());
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        KtExpression firstArgumentExpression = PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3);
        if (!(firstArgumentExpression instanceof KtLambdaExpression)) {
            KtExpression ktExpression = firstArgumentExpression;
            if (ktExpression == null) {
                ktExpression = this.callContext.getContractCallExpression();
            }
            KtExpression reportOn = ktExpression;
            this.collector.badDescription("first argument of 'contract'-call should be a lambda expression", (KtElement)reportOn);
            return null;
        }
        KtLambdaExpression lambda = (KtLambdaExpression)firstArgumentExpression;
        Object object = lambda.getBodyExpression();
        if (object != null && (object = object.getStatements()) != null) {
            void $this$mapTo$iv$iv;
            $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)this.parseEffect((KtExpression)it), (Object)it));
            }
        } else {
            return null;
        }
        List effectsWithExpression = (List)destination$iv$iv;
        this.checkDuplicatedCallsEffectsAndReport(effectsWithExpression);
        Iterable $this$mapNotNull$iv = effectsWithExpression;
        boolean $i$f$mapNotNull = false;
        $this$map$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            EffectDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((EffectDeclaration)it.getFirst() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List effects = (List)destination$iv$iv2;
        if (effects.isEmpty()) {
            return null;
        }
        return new ContractDescription(effects, this.callContext.getFunctionDescriptor(), this.storageManager);
    }

    @Nullable
    public final BooleanExpression parseCondition(@Nullable KtExpression expression2) {
        KtExpression ktExpression = expression2;
        return ktExpression != null ? (BooleanExpression)ktExpression.accept((KtVisitor)this.conditionParser, (Object)Unit.INSTANCE) : null;
    }

    @Nullable
    public final EffectDeclaration parseEffect(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (!this.isValidEffectDeclaration(expression2)) {
            return null;
        }
        KotlinType kotlinType = CallUtilKt.getType(expression2, this.callContext.getBindingContext());
        if (kotlinType == null) {
            return null;
        }
        KotlinType returnType = kotlinType;
        Map<Name, PsiEffectParser> map = this.effectsParsers;
        ClassifierDescriptor classifierDescriptor = returnType.getConstructor().getDeclarationDescriptor();
        PsiEffectParser parser = map.get(classifierDescriptor != null ? classifierDescriptor.getName() : null);
        if (parser == null) {
            this.collector.badDescription("unrecognized effect", (KtElement)expression2);
            return null;
        }
        return parser.tryParseEffect(expression2);
    }

    private final void checkDuplicatedCallsEffectsAndReport(List<? extends Pair<? extends EffectDeclaration, ? extends KtExpression>> effects) {
        Set descriptorsWithCallsEffect = new LinkedHashSet();
        for (Pair<? extends EffectDeclaration, ? extends KtExpression> pair : effects) {
            EffectDeclaration effect = (EffectDeclaration)pair.component1();
            KtExpression expression2 = (KtExpression)pair.component2();
            if (!(effect instanceof CallsEffectDeclaration)) continue;
            ParameterDescriptor descriptor = ((CallsEffectDeclaration)effect).getVariableReference().getDescriptor();
            if (descriptorsWithCallsEffect.contains(descriptor)) {
                this.collector.badDescription("Duplicated contract for " + descriptor.getName() + ". Only one `callsInPlace` contract per parameter is allowed.", (KtElement)expression2);
                continue;
            }
            descriptorsWithCallsEffect.add(descriptor);
        }
    }

    private final boolean isValidEffectDeclaration(KtExpression expression2) {
        if (!(expression2 instanceof KtCallExpression) && !(expression2 instanceof KtBinaryExpression)) {
            this.collector.badDescription("unexpected construction in contract description", (KtElement)expression2);
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)expression2, this.callContext.getBindingContext());
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resultingDescriptor = resolvedCall2;
        if (!PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)((Object)resultingDescriptor))) {
            this.collector.badDescription("effects can be produced only by direct calls to ContractsDSL", (KtElement)expression2);
            return false;
        }
        return true;
    }

    @Nullable
    public final ConstantReference parseConstant(@Nullable KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        return (ConstantReference)expression2.accept((KtVisitor)this.constantParser, (Object)Unit.INSTANCE);
    }

    @Nullable
    public final VariableReference parseVariable(@Nullable KtExpression expression2) {
        CallableDescriptor descriptor;
        if (expression2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)expression2, this.callContext.getBindingContext());
        CallableDescriptor callableDescriptor = descriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (!(descriptor instanceof ParameterDescriptor)) {
            if (!(expression2 instanceof KtConstantExpression)) {
                this.collector.badDescription("only references to parameters are allowed in contract description", (KtElement)expression2);
            }
            return null;
        }
        if (descriptor instanceof ReceiverParameterDescriptor) {
            ReceiverParameterDescriptor directReceiver;
            ClassifierDescriptor classifierDescriptor = ((ReceiverParameterDescriptor)descriptor).getType().getConstructor().getDeclarationDescriptor();
            boolean bl = classifierDescriptor != null ? PsiContractsUtilsKt.isFromContractDsl(classifierDescriptor) : false;
            if (bl) {
                this.collector.badDescription("only references to parameters are allowed. Did you miss label on <this>?", (KtElement)expression2);
                return null;
            }
            FunctionDescriptor it = this.callContext.getFunctionDescriptor();
            boolean bl2 = false;
            ReceiverParameterDescriptor receiverParameterDescriptor = it.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                receiverParameterDescriptor = it.getDispatchReceiverParameter();
            }
            if (!Intrinsics.areEqual((Object)descriptor, (Object)(directReceiver = receiverParameterDescriptor))) {
                this.collector.badDescription("only references to direct <this> are allowed", (KtElement)expression2);
                return null;
            }
        }
        return KotlinBuiltIns.isBoolean(((ParameterDescriptor)descriptor).getType()) ? (VariableReference)new BooleanVariableReference((ParameterDescriptor)descriptor) : new VariableReference((ParameterDescriptor)descriptor);
    }

    @Nullable
    public final ContractDescriptionValue parseValue(@Nullable KtExpression expression2) {
        VariableReference variable = this.parseVariable(expression2);
        if (variable != null) {
            return variable;
        }
        return this.parseConstant(expression2);
    }
}

