/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.ParticleVisitor;
import com.thaiopensource.xml.infer.SequenceParticle;
import com.thaiopensource.xml.infer.TextParticle;

public class ParticleDumper
implements ParticleVisitor {
    private final String defaultNamespace;

    private ParticleDumper(String string) {
        this.defaultNamespace = string;
    }

    public static String toString(Particle particle, String string) {
        return new ParticleDumper(string).convert(particle);
    }

    private String convert(Particle particle) {
        return (String)particle.accept(this);
    }

    public Object visitElement(ElementParticle elementParticle) {
        Name name = elementParticle.getName();
        String string = name.getNamespaceUri();
        if (string.equals(this.defaultNamespace)) {
            return name.getLocalName();
        }
        return "{" + name.getNamespaceUri() + "}" + name.getLocalName();
    }

    public Object visitChoice(ChoiceParticle choiceParticle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        this.convertForChoice(choiceParticle, stringBuffer);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void convertForChoice(Particle particle, StringBuffer stringBuffer) {
        if (particle instanceof ChoiceParticle) {
            this.convertForChoice((ChoiceParticle)particle, stringBuffer);
        } else {
            stringBuffer.append(this.convert(particle));
        }
    }

    private void convertForChoice(ChoiceParticle choiceParticle, StringBuffer stringBuffer) {
        this.convertForChoice(choiceParticle.getChild1(), stringBuffer);
        stringBuffer.append('|');
        this.convertForChoice(choiceParticle.getChild2(), stringBuffer);
    }

    public Object visitSequence(SequenceParticle sequenceParticle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        this.convertForSequence(sequenceParticle, stringBuffer);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void convertForSequence(Particle particle, StringBuffer stringBuffer) {
        if (particle instanceof SequenceParticle) {
            this.convertForSequence((SequenceParticle)particle, stringBuffer);
        } else {
            stringBuffer.append(this.convert(particle));
        }
    }

    private void convertForSequence(SequenceParticle sequenceParticle, StringBuffer stringBuffer) {
        this.convertForSequence(sequenceParticle.getChild1(), stringBuffer);
        stringBuffer.append(',');
        this.convertForSequence(sequenceParticle.getChild2(), stringBuffer);
    }

    public Object visitEmpty(EmptyParticle emptyParticle) {
        return "#empty";
    }

    public Object visitText(TextParticle textParticle) {
        return "#text";
    }

    public Object visitOneOrMore(OneOrMoreParticle oneOrMoreParticle) {
        return this.convert(oneOrMoreParticle.getChild()) + "+";
    }
}

