/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Create a map of the approximate signed distance from the boundaries of
a binary image.


The ApproximateSignedDistanceMapImageFilter takes as input a binary image and produces a signed distance map.
Each pixel value in the output contains the approximate distance from
that pixel to the nearest "object" in the binary image. This filter
differs from the DanielssonDistanceMapImageFilter in that it calculates the distance to the "object edge" for pixels
within the object.

Negative values in the output indicate that the pixel at that position
is within an object in the input image. The absolute value of a
negative pixel represents the approximate distance to the nearest
object boundary pixel.

WARNING: This filter requires that the output type be floating-point.
Otherwise internal calculations will not be performed to the
appropriate precision, resulting in completely incorrect (read: zero-
valued) output.

The distances computed by this filter are Chamfer distances, which are
only an approximation to Euclidean distances, and are not as exact
approximations as those calculated by the DanielssonDistanceMapImageFilter . On the other hand, this filter is faster.

This filter requires that an "inside value" and "outside value" be
set as parameters. The "inside value" is the intensity value of the
binary image which corresponds to objects, and the "outside value"
is the intensity of the background. (A typical binary image often
represents objects as black (0) and background as white (usually 255),
or vice-versa.) Note that this filter is slightly faster if the inside
value is less than the outside value. Otherwise an extra iteration
through the image is required.

This filter uses the FastChamferDistanceImageFilter and the IsoContourDistanceImageFilter internally to perform the distance calculations.


See:
 DanielssonDistanceMapImageFilter

 SignedDanielssonDistanceMapImageFilter

 SignedMaurerDistanceMapImageFilter

 FastChamferDistanceImageFilter

 IsoContourDistanceImageFilter

Zach Pincus

See:
 itk::simple::ApproximateSignedDistanceMap for the procedural interface

 itk::ApproximateSignedDistanceMapImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkApproximateSignedDistanceMapImageFilter.h
*/
public class ApproximateSignedDistanceMapImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ApproximateSignedDistanceMapImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ApproximateSignedDistanceMapImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ApproximateSignedDistanceMapImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ApproximateSignedDistanceMapImageFilter::~ApproximateSignedDistanceMapImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ApproximateSignedDistanceMapImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ApproximateSignedDistanceMapImageFilter::ApproximateSignedDistanceMapImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ApproximateSignedDistanceMapImageFilter() {
    this(SimpleITKJNI.new_ApproximateSignedDistanceMapImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ApproximateSignedDistanceMapImageFilter::SetInsideValue(double InsideValue)

Set/Get intensity value representing the interior of objects in the
mask.

*/
public  void setInsideValue(double InsideValue) {
    SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_setInsideValue(swigCPtr, this, InsideValue);
  }

  /**
double itk::simple::ApproximateSignedDistanceMapImageFilter::GetInsideValue() const

Set/Get intensity value representing the interior of objects in the
mask.

*/
public  double getInsideValue() {
    return SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_getInsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ApproximateSignedDistanceMapImageFilter::SetOutsideValue(double OutsideValue)

Set/Get intensity value representing non-objects in the mask.

*/
public  void setOutsideValue(double OutsideValue) {
    SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
double itk::simple::ApproximateSignedDistanceMapImageFilter::GetOutsideValue() const

Set/Get intensity value representing non-objects in the mask.

*/
public  double getOutsideValue() {
    return SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
std::string itk::simple::ApproximateSignedDistanceMapImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ApproximateSignedDistanceMapImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ApproximateSignedDistanceMapImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ApproximateSignedDistanceMapImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
