/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Edge enhancement filter.


This filter subtracts a smoothed version of the image from the image
to achieve the edge enhancing effect. https://en.wikipedia.org/w/index.php?title=Unsharp_masking&amp;oldid=7
50486803#Photographic_unsharp_masking

It has configurable amount, radius (sigma) and threshold, and whether
to clamp the resulting values to the range of output type.

Formula: sharpened=original+[ itk::Math::abs (original-blurred)-threshold]*amount

If clamping is turned off (it is on by default), casting to output
pixel format is done using C++ defaults, meaning that values are not
clamped but rather wrap around e.g. 260 -&gt; 4 (unsigned char).


See:
 ImageToImageFilter

 SmoothingRecursiveGaussianImageFilter

 RescaleIntensityImageFilter

 itk::simple::UnsharpMask for the procedural interface

 itk::UnsharpMaskImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkUnsharpMaskImageFilter.h
*/
public class UnsharpMaskImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected UnsharpMaskImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.UnsharpMaskImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(UnsharpMaskImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(UnsharpMaskImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::UnsharpMaskImageFilter::~UnsharpMaskImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_UnsharpMaskImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::UnsharpMaskImageFilter::UnsharpMaskImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  UnsharpMaskImageFilter() {
    this(SimpleITKJNI.new_UnsharpMaskImageFilter(), true);
  }

  /**
Self&amp; itk::simple::UnsharpMaskImageFilter::SetSigmas(std::vector&lt; double &gt; Sigmas)

Set/Get Sigma values measured in the units of image spacing. Default:
1.0.

*/
public  void setSigmas(double s) {
    SimpleITKJNI.UnsharpMaskImageFilter_setSigmas__SWIG_0(swigCPtr, this, s);
  }

  /**
Self&amp; itk::simple::UnsharpMaskImageFilter::SetSigmas(std::vector&lt; double &gt; Sigmas)

Set/Get Sigma values measured in the units of image spacing. Default:
1.0.

*/
public  void setSigmas(VectorDouble Sigmas) {
    SimpleITKJNI.UnsharpMaskImageFilter_setSigmas__SWIG_1(swigCPtr, this, VectorDouble.getCPtr(Sigmas), Sigmas);
  }

  /**
std::vector&lt;double&gt; itk::simple::UnsharpMaskImageFilter::GetSigmas() const

Set/Get Sigma values measured in the units of image spacing. Default:
1.0.

*/
public  VectorDouble getSigmas() {
    return new VectorDouble(SimpleITKJNI.UnsharpMaskImageFilter_getSigmas(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::UnsharpMaskImageFilter::SetAmount(double Amount)

Set/Get amount of enhancement. Usual range: 0.1 to 2.0. Default: 0.5.

*/
public  void setAmount(double Amount) {
    SimpleITKJNI.UnsharpMaskImageFilter_setAmount(swigCPtr, this, Amount);
  }

  /**
double itk::simple::UnsharpMaskImageFilter::GetAmount() const

Set/Get amount of enhancement. Usual range: 0.1 to 2.0. Default: 0.5.

*/
public  double getAmount() {
    return SimpleITKJNI.UnsharpMaskImageFilter_getAmount(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::UnsharpMaskImageFilter::SetThreshold(double Threshold)

Set/Get threshold for enhancement. Default: 0.

*/
public  void setThreshold(double Threshold) {
    SimpleITKJNI.UnsharpMaskImageFilter_setThreshold(swigCPtr, this, Threshold);
  }

  /**
double itk::simple::UnsharpMaskImageFilter::GetThreshold() const

Set/Get threshold for enhancement. Default: 0.

*/
public  double getThreshold() {
    return SimpleITKJNI.UnsharpMaskImageFilter_getThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::UnsharpMaskImageFilter::SetClamp(bool Clamp)

Set/Get whether to clamp values to supported range of output type.
Default: On.

*/
public  void setClamp(boolean Clamp) {
    SimpleITKJNI.UnsharpMaskImageFilter_setClamp(swigCPtr, this, Clamp);
  }

  /**
Self&amp; itk::simple::UnsharpMaskImageFilter::ClampOn()

Set the value of Clamp to true or false respectfully.

*/
public  void clampOn() {
    SimpleITKJNI.UnsharpMaskImageFilter_clampOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::UnsharpMaskImageFilter::ClampOff()
*/
public  void clampOff() {
    SimpleITKJNI.UnsharpMaskImageFilter_clampOff(swigCPtr, this);
  }

  /**
bool itk::simple::UnsharpMaskImageFilter::GetClamp() const

Set/Get whether to clamp values to supported range of output type.
Default: On.

*/
public  boolean getClamp() {
    return SimpleITKJNI.UnsharpMaskImageFilter_getClamp(swigCPtr, this);
  }

  /**
std::string itk::simple::UnsharpMaskImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.UnsharpMaskImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::UnsharpMaskImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.UnsharpMaskImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::UnsharpMaskImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.UnsharpMaskImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
