/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.security.cert.X509Certificate;
import org.keycloak.common.util.PemException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.services.x509.AbstractClientCertificateFromHttpHeadersLookup;

public class ApacheProxySslClientCertificateLookup
extends AbstractClientCertificateFromHttpHeadersLookup {
    public ApacheProxySslClientCertificateLookup(String sslCientCertHttpHeader, String sslCertChainHttpHeaderPrefix, int certificateChainLength) {
        super(sslCientCertHttpHeader, sslCertChainHttpHeaderPrefix, certificateChainLength);
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replace("-----BEGIN CERTIFICATE-----", "");
        pem = pem.replace("-----END CERTIFICATE-----", "");
        pem = pem.replace("\r\n", "");
        pem = pem.replace("\n", "");
        return pem.trim();
    }

    @Override
    protected X509Certificate decodeCertificateFromPem(String pem) throws PemException {
        if (pem == null) {
            return null;
        }
        if (pem.startsWith("-----BEGIN CERTIFICATE-----")) {
            pem = ApacheProxySslClientCertificateLookup.removeBeginEnd(pem);
        }
        return PemUtils.decodeCertificate((String)pem);
    }
}

