/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;

public class AggregateColumnWriteExpression
implements Expression,
AggregateSupport.AggregateColumnWriteExpression {
    private final ColumnReference aggregateColumnReference;
    private final SelectableMapping[] selectableMappings;
    private final Expression[] valueExpressions;
    private final AggregateSupport.WriteExpressionRenderer columnWriter;

    public AggregateColumnWriteExpression(ColumnReference aggregateColumnReference, AggregateSupport.WriteExpressionRenderer columnWriter, SelectableMapping[] selectableMappings, Expression[] valueExpressions) {
        this.aggregateColumnReference = aggregateColumnReference;
        this.selectableMappings = selectableMappings;
        this.valueExpressions = valueExpressions;
        this.columnWriter = columnWriter;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.aggregateColumnReference.getExpressionType();
    }

    @Override
    public ColumnReference getColumnReference() {
        return this.aggregateColumnReference;
    }

    public ColumnReference getAggregateColumnReference() {
        return this.aggregateColumnReference;
    }

    public SelectableMapping[] getSelectableMappings() {
        return this.selectableMappings;
    }

    public Expression[] getValueExpressions() {
        return this.valueExpressions;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitAggregateColumnWriteExpression(this);
    }

    @Override
    public Expression getValueExpression(SelectableMapping selectableMapping) {
        for (int i = 0; i < this.selectableMappings.length; ++i) {
            if (selectableMapping != this.selectableMappings[i]) continue;
            return this.valueExpressions[i];
        }
        throw new IllegalArgumentException("Couldn't find value expression for selectable mapping: " + String.valueOf(selectableMapping));
    }

    public void appendWriteExpression(SqlAstTranslator<?> translator, SqlAppender appender) {
        this.appendWriteExpression(translator, appender, this.aggregateColumnReference.getQualifier());
    }

    public void appendWriteExpression(SqlAstTranslator<?> translator, SqlAppender appender, String qualifier) {
        this.columnWriter.render(appender, translator, this, qualifier);
    }
}

