/*
 * Decompiled with CFR 0.152.
 */
package org.aesh;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.readline.Prompt;
import org.aesh.readline.ReadlineConsole;
import org.aesh.terminal.Connection;

public class AeshConsoleRunner {
    private List<Class<? extends Command>> commands = new ArrayList<Class<? extends Command>>();
    private Settings settings;
    private Prompt prompt;
    private ReadlineConsole console;
    private Connection connection;

    private AeshConsoleRunner() {
    }

    public static AeshConsoleRunner builder() {
        return new AeshConsoleRunner();
    }

    public AeshConsoleRunner commands(Class<? extends Command> ... commands) {
        if (commands != null) {
            this.commands.addAll(Arrays.asList(commands));
        }
        return this;
    }

    public AeshConsoleRunner command(Class<? extends Command> commands) {
        if (commands != null) {
            this.commands.add(commands);
        }
        return this;
    }

    public AeshConsoleRunner commands(List<Class<Command>> commands) {
        if (commands != null) {
            this.commands.addAll(commands);
        }
        return this;
    }

    public AeshConsoleRunner settings(Settings settings) {
        if (settings != null) {
            this.settings = settings;
        }
        return this;
    }

    public AeshConsoleRunner connection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public AeshConsoleRunner prompt(String prompt) {
        if (prompt != null) {
            this.prompt = new Prompt(prompt);
        }
        if (this.console != null && this.console.running()) {
            this.console.setPrompt(this.prompt);
        }
        return this;
    }

    public AeshConsoleRunner prompt(Prompt prompt) {
        if (prompt != null) {
            this.prompt = prompt;
        }
        if (this.console != null && this.console.running()) {
            this.console.setPrompt(this.prompt);
        }
        return this;
    }

    public AeshConsoleRunner addExitCommand() {
        this.commands.add(ExitCommand.class);
        return this;
    }

    public void start() {
        if (this.console == null) {
            this.init();
            if (this.prompt != null) {
                this.console.setPrompt(this.prompt);
            }
            try {
                this.console.start();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while starting the console: " + e.getMessage());
            }
        }
    }

    public void stop() {
        if (this.console != null && this.console.running()) {
            this.console.stop();
        }
    }

    private void init() {
        if (this.commands.isEmpty() && (this.settings == null || this.settings.commandRegistry() == null || this.settings.commandRegistry().getAllCommandNames().isEmpty())) {
            throw new RuntimeException("No commands added, nothing to run");
        }
        try {
            if (this.settings == null) {
                AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
                for (Class<? extends Command> command : this.commands) {
                    registryBuilder.command(command);
                }
                this.settings = SettingsBuilder.builder().commandRegistry(registryBuilder.create()).enableAlias(false).enableExport(false).enableMan(false).persistHistory(false).connection(this.connection).build();
            } else if (!this.commands.isEmpty() && (this.settings.commandRegistry() == null || this.settings.commandRegistry().getAllCommandNames().isEmpty())) {
                AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
                for (Class<? extends Command> command : this.commands) {
                    registryBuilder.command(command);
                }
                SettingsBuilder settingsBuilder = new SettingsBuilder(this.settings).commandRegistry(registryBuilder.create());
                if (this.connection != null) {
                    settingsBuilder.connection(this.connection);
                }
                this.settings = settingsBuilder.build();
            }
            this.console = new ReadlineConsole(this.settings);
        }
        catch (CommandRegistryException e) {
            throw new RuntimeException("Error when adding command: " + e.getMessage());
        }
    }

    @CommandDefinition(name="exit", description="exit the program", aliases={"quit"})
    public static class ExitCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) {
            commandInvocation.stop();
            return CommandResult.SUCCESS;
        }
    }
}

