/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmTuple<T>
extends AbstractSqmExpression<T>
implements JpaCompoundSelection<T> {
    private final List<SqmExpression<?>> groupedExpressions;

    public SqmTuple(NodeBuilder nodeBuilder, SqmExpression<?> ... groupedExpressions) {
        this(Arrays.asList(groupedExpressions), nodeBuilder);
    }

    public SqmTuple(NodeBuilder nodeBuilder, SqmBindableType<T> type, SqmExpression<?> ... groupedExpressions) {
        this(Arrays.asList(groupedExpressions), type, nodeBuilder);
    }

    public SqmTuple(List<SqmExpression<?>> groupedExpressions, NodeBuilder nodeBuilder) {
        this(groupedExpressions, null, nodeBuilder);
    }

    public SqmTuple(List<SqmExpression<?>> groupedExpressions, SqmBindableType<T> type, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        if (groupedExpressions.isEmpty()) {
            throw new SemanticException("Tuple constructor must have at least one element");
        }
        this.groupedExpressions = groupedExpressions;
        if (type == null) {
            this.setExpressibleType(nodeBuilder.getTypeConfiguration().resolveTupleType(groupedExpressions));
        }
    }

    @Override
    public SqmTuple<T> copy(SqmCopyContext context) {
        SqmTuple existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList groupedExpressions = new ArrayList(this.groupedExpressions.size());
        for (SqmExpression<?> groupedExpression : this.groupedExpressions) {
            groupedExpressions.add((SqmExpression<?>)groupedExpression.copy(context));
        }
        SqmTuple expression = context.registerCopy(this, new SqmTuple(groupedExpressions, this.getNodeType(), this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    public List<SqmExpression<?>> getGroupedExpressions() {
        return this.groupedExpressions;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTuple(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append('(');
        this.groupedExpressions.get(0).appendHqlString(hql, context);
        for (int i = 1; i < this.groupedExpressions.size(); ++i) {
            hql.append(", ");
            this.groupedExpressions.get(i).appendHqlString(hql, context);
        }
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmTuple)) return false;
        SqmTuple that = (SqmTuple)object;
        if (!Objects.equals(this.groupedExpressions, that.groupedExpressions)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.groupedExpressions);
    }

    @Override
    public String asLoggableText() {
        return this.toString();
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return this.getGroupedExpressions();
    }

    @Override
    public Integer getTupleLength() {
        return this.groupedExpressions.size();
    }
}

