/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.keycloak.common.util.StreamUtil;

public class IoUtil {
    public static String readFileOrStdin(String file) {
        String content;
        if ("-".equals(file)) {
            content = IoUtil.readFully(System.in);
        } else {
            try (FileInputStream is = new FileInputStream(file);){
                content = IoUtil.readFully(is);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("File not found: " + file);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + file, e);
            }
        }
        return content;
    }

    public static String readFully(InputStream is) {
        try {
            return StreamUtil.readString(is, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read stream", e);
        }
    }

    public static void copyStream(InputStream is, OutputStream os) {
        byte[] buf = new byte[8192];
        try (InputStream input = is;){
            int rc;
            while ((rc = input.read(buf)) != -1) {
                os.write(buf, 0, rc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read/write a stream: ", e);
        }
        finally {
            try {
                os.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write a stream: ", e);
            }
        }
    }

    public static void ensureFile(Path path) throws IOException {
        FileSystem fs = FileSystems.getDefault();
        Set<String> supportedViews = fs.supportedFileAttributeViews();
        Path parent = path.getParent();
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
            if (supportedViews.contains("posix")) {
                IoUtil.setUnixPermissions(parent);
            } else if (supportedViews.contains("acl")) {
                IoUtil.setWindowsPermissions(parent);
            } else {
                IoUtil.warnErr("Failed to restrict access permissions on .keycloak directory: " + String.valueOf(parent));
            }
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                IoUtil.setUnixPermissions(path);
            } else if (supportedViews.contains("acl")) {
                IoUtil.setWindowsPermissions(path);
            } else {
                IoUtil.warnErr("Failed to restrict access permissions on config file: " + String.valueOf(path));
            }
        }
    }

    private static void setUnixPermissions(Path path) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        if (Files.isDirectory(path, new LinkOption[0])) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        Files.setPosixFilePermissions(path, perms);
    }

    private static void setWindowsPermissions(Path path) throws IOException {
        AclEntry entry;
        AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        UserPrincipal owner = view.getOwner();
        List<AclEntry> acl = view.getAcl();
        ListIterator<AclEntry> it = acl.listIterator();
        while (it.hasNext()) {
            entry = it.next();
            if ("BUILTIN\\Administrators".equals(entry.principal().getName()) || "NT AUTHORITY\\SYSTEM".equals(entry.principal().getName())) continue;
            it.remove();
        }
        entry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(owner).setPermissions(AclEntryPermission.READ_DATA, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.EXECUTE, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.DELETE, AclEntryPermission.READ_ACL, AclEntryPermission.SYNCHRONIZE).build();
        acl.add(entry);
        view.setAcl(acl);
    }

    public static void printOut(String msg) {
        System.out.println(msg);
    }

    public static void printErr(String msg) {
        System.err.println(msg);
    }

    public static void printfOut(String format, String ... params) {
        System.out.println(new Formatter().format("WARN: " + format, params));
    }

    public static void warnOut(String msg) {
        System.out.println("WARN: " + msg);
    }

    public static void warnErr(String msg) {
        System.err.println("WARN: " + msg);
    }

    public static void warnfOut(String format, String ... params) {
        System.out.println(new Formatter().format("WARN: " + format, params));
    }

    public static void warnfErr(String format, String ... params) {
        System.err.println(new Formatter().format("WARN: " + format, params));
    }

    public static void logOut(String msg) {
        System.out.println("LOG: " + msg);
    }
}

