/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class MultiConcatMapOp<I, O>
extends AbstractMultiOperator<I, O> {
    private final Function<? super I, ? extends Flow.Publisher<? extends O>> mapper;
    private final boolean postponeFailurePropagation;

    public MultiConcatMapOp(Multi<? extends I> upstream, Function<? super I, ? extends Flow.Publisher<? extends O>> mapper, boolean postponeFailurePropagation) {
        super(upstream);
        this.mapper = mapper;
        this.postponeFailurePropagation = postponeFailurePropagation;
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        MainSubscriber<? super I, ? super O> sub = new MainSubscriber<I, O>(this.mapper, this.postponeFailurePropagation, subscriber);
        this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, sub));
    }

    private static class MainSubscriber<I, O>
    implements MultiSubscriber<I>,
    Flow.Subscription,
    ContextSupport {
        private final Function<? super I, ? extends Flow.Publisher<? extends O>> mapper;
        private final boolean postponeFailurePropagation;
        private final MultiSubscriber<? super O> downstream;
        private volatile State state = State.INIT;
        private static final AtomicReferenceFieldUpdater<MainSubscriber, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MainSubscriber.class, State.class, "state");
        private volatile long demand = 0L;
        private static final AtomicLongFieldUpdater<MainSubscriber> DEMAND_UPDATER = AtomicLongFieldUpdater.newUpdater(MainSubscriber.class, "demand");
        private final InnerSubscriber innerSubscriber = new InnerSubscriber();
        private final ReentrantLock stateLock = new ReentrantLock();
        private volatile Throwable failure;
        private Flow.Subscription mainUpstream;
        private volatile Flow.Subscription innerUpstream;

        private MainSubscriber(Function<? super I, ? extends Flow.Publisher<? extends O>> mapper, boolean postponeFailurePropagation, MultiSubscriber<? super O> downstream) {
            this.mapper = mapper;
            this.postponeFailurePropagation = postponeFailurePropagation;
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (STATE_UPDATER.compareAndSet(this, State.INIT, State.READY)) {
                this.mainUpstream = subscription;
                this.downstream.onSubscribe(this);
            } else {
                subscription.cancel();
            }
        }

        private void innerOnSubscribe(Flow.Subscription subscription) {
            this.stateLock.lock();
            this.innerUpstream = subscription;
            long n = this.demand;
            this.stateLock.unlock();
            if (n > 0L) {
                subscription.request(n);
            }
        }

        @Override
        public void onItem(I item) {
            if (STATE_UPDATER.compareAndSet(this, State.PUBLISHER_REQUESTED, State.EMITTING)) {
                try {
                    Flow.Publisher<O> publisher = Objects.requireNonNull(this.mapper.apply(item), "The mapper produced a null publisher");
                    publisher.subscribe(this.innerSubscriber);
                }
                catch (Throwable err) {
                    this.state = State.DONE;
                    this.mainUpstream.cancel();
                    this.downstream.onFailure(this.addFailure(err));
                }
            }
        }

        private void innerOnItem(O item) {
            if (this.state != State.DONE) {
                if (this.demand < Long.MAX_VALUE) {
                    DEMAND_UPDATER.decrementAndGet(this);
                }
                this.downstream.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (STATE_UPDATER.getAndSet(this, State.DONE) != State.DONE) {
                if (this.innerUpstream != null) {
                    this.innerUpstream.cancel();
                }
                this.downstream.onFailure(this.addFailure(failure));
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }

        private void innerOnFailure(Throwable failure) {
            Throwable throwable = this.addFailure(failure);
            this.stateLock.lock();
            switch (this.state.ordinal()) {
                case 3: {
                    if (this.postponeFailurePropagation) {
                        if (this.demand > 0L) {
                            this.state = State.PUBLISHER_REQUESTED;
                            this.stateLock.unlock();
                            this.mainUpstream.request(1L);
                            break;
                        }
                        this.state = State.READY;
                        this.stateLock.unlock();
                        break;
                    }
                    this.state = State.DONE;
                    this.stateLock.unlock();
                    this.mainUpstream.cancel();
                    this.downstream.onFailure(throwable);
                    break;
                }
                case 4: {
                    this.state = State.DONE;
                    this.stateLock.unlock();
                    this.mainUpstream.cancel();
                    this.downstream.onFailure(throwable);
                    break;
                }
                default: {
                    this.stateLock.unlock();
                    Infrastructure.handleDroppedException(failure);
                }
            }
        }

        private Throwable addFailure(Throwable failure) {
            this.failure = this.failure != null ? (this.failure instanceof CompositeException ? new CompositeException((CompositeException)this.failure, failure) : new CompositeException(this.failure, failure)) : failure;
            return this.failure;
        }

        @Override
        public void onCompletion() {
            this.stateLock.lock();
            switch (this.state.ordinal()) {
                case 3: {
                    this.state = State.EMITTING_FINAL;
                    this.stateLock.unlock();
                    break;
                }
                case 1: 
                case 2: {
                    this.stateLock.unlock();
                    this.terminate();
                    break;
                }
                default: {
                    this.stateLock.unlock();
                }
            }
        }

        private void innerOnCompletion() {
            this.stateLock.lock();
            switch (this.state.ordinal()) {
                case 3: {
                    if (this.demand > 0L) {
                        this.state = State.PUBLISHER_REQUESTED;
                        this.stateLock.unlock();
                        this.mainUpstream.request(1L);
                        break;
                    }
                    this.state = State.READY;
                    this.stateLock.unlock();
                    break;
                }
                case 4: {
                    this.stateLock.unlock();
                    this.terminate();
                    break;
                }
                default: {
                    this.stateLock.unlock();
                }
            }
        }

        private void terminate() {
            if (STATE_UPDATER.getAndSet(this, State.DONE) != State.DONE) {
                if (this.failure != null) {
                    this.downstream.onFailure(this.failure);
                } else {
                    this.downstream.onCompletion();
                }
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.state = State.DONE;
                this.downstream.onFailure(Subscriptions.getInvalidRequestException());
            } else {
                Subscriptions.add(DEMAND_UPDATER, this, n);
                this.stateLock.lock();
                switch (this.state.ordinal()) {
                    case 3: 
                    case 4: {
                        this.stateLock.unlock();
                        if (this.innerUpstream == null) break;
                        this.innerUpstream.request(n);
                        break;
                    }
                    case 1: {
                        this.state = State.PUBLISHER_REQUESTED;
                        this.stateLock.unlock();
                        this.mainUpstream.request(1L);
                        break;
                    }
                    default: {
                        this.stateLock.unlock();
                    }
                }
            }
        }

        @Override
        public void cancel() {
            this.mainUpstream.cancel();
            if (this.innerUpstream != null) {
                this.innerUpstream.cancel();
            }
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)((Object)this.downstream)).context();
            }
            return Context.empty();
        }

        private class InnerSubscriber
        implements MultiSubscriber<O>,
        ContextSupport {
            private InnerSubscriber() {
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                MainSubscriber.this.innerOnSubscribe(subscription);
            }

            @Override
            public void onItem(O item) {
                MainSubscriber.this.innerOnItem(item);
            }

            @Override
            public void onFailure(Throwable failure) {
                MainSubscriber.this.innerOnFailure(failure);
            }

            @Override
            public void onCompletion() {
                MainSubscriber.this.innerOnCompletion();
            }

            @Override
            public Context context() {
                if (MainSubscriber.this.downstream instanceof ContextSupport) {
                    return ((ContextSupport)((Object)MainSubscriber.this.downstream)).context();
                }
                return Context.empty();
            }
        }
    }

    private static enum State {
        INIT,
        READY,
        PUBLISHER_REQUESTED,
        EMITTING,
        EMITTING_FINAL,
        DONE;

    }
}

