/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.concurrency;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.concurrency.WorkerThreadFactory;

public final class ExecutorUtils {
    public static final Executor DIRECT_EXECUTOR = Runnable::run;

    public static ExecutorService threadPool(int poolSize, String namePrefix) {
        if (poolSize < 2) {
            throw new IllegalArgumentException("Invalid poolSize: " + poolSize + ". Must be greater than 1.");
        }
        return new ThreadPoolExecutor(poolSize, poolSize, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory(namePrefix));
    }

    public static Executor executor(int size, String namePrefix) {
        if (size <= 1) {
            return DIRECT_EXECUTOR;
        }
        return ExecutorUtils.threadPool(size, namePrefix);
    }

    public static void shutdown(Executor executor) {
        if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).shutdown();
        }
    }

    public static int threadCount(RepositorySystemSession session, int defaultValue, String ... keys) {
        if (defaultValue < 1) {
            throw new IllegalArgumentException("Invalid defaultValue: " + defaultValue + ". Must be greater than 0.");
        }
        int threadCount = ConfigUtils.getInteger(session, defaultValue, keys);
        if (threadCount < 1) {
            throw new IllegalArgumentException("Invalid value: " + threadCount + ". Must be greater than 0.");
        }
        return threadCount;
    }
}

