/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.helpers;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.swing.table.TableModel;
import mediathek.controller.SenderFilmlistLoadApprover;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.tool.FilterConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class GuiModelHelper {
    private static final long UNLIMITED_LENGTH_IN_SECONDS = TimeUnit.SECONDS.convert(240L, TimeUnit.MINUTES);
    protected final SeenHistoryController historyController;
    protected final SearchFieldData searchFieldData;
    protected final FilterConfiguration filterConfiguration;
    private long minLengthInSeconds;
    private long maxLengthInSeconds = UNLIMITED_LENGTH_IN_SECONDS;

    protected GuiModelHelper(@NotNull SeenHistoryController historyController, @NotNull SearchFieldData searchFieldData, @NotNull FilterConfiguration filterConfiguration) {
        this.historyController = historyController;
        this.searchFieldData = searchFieldData;
        this.filterConfiguration = filterConfiguration;
    }

    public abstract TableModel getFilteredTableModel();

    protected boolean maxLengthCheck(DatenFilm film) {
        return (long)film.getFilmLength() < this.maxLengthInSeconds;
    }

    protected boolean minLengthCheck(DatenFilm film) {
        int filmLength = film.getFilmLength();
        if (filmLength == 0) {
            return true;
        }
        return (long)filmLength >= this.minLengthInSeconds;
    }

    public Stream<DatenFilm> applyCommonFilters(Stream<DatenFilm> stream, String filterThema) {
        if (!filterThema.isEmpty()) {
            stream = stream.filter(film -> film.getThema().equalsIgnoreCase(filterThema));
        }
        if (this.maxLengthInSeconds < UNLIMITED_LENGTH_IN_SECONDS) {
            stream = stream.filter(this::maxLengthCheck);
        }
        if (this.filterConfiguration.isShowUnseenOnly()) {
            stream = stream.filter(this::seenCheck);
        }
        return stream.filter(this::minLengthCheck);
    }

    protected boolean noFiltersAreSet() {
        return this.filterConfiguration.noFiltersAreSet() && this.searchFieldData.isEmpty();
    }

    protected List<String> getSelectedSendersFromFilter() {
        return this.filterConfiguration.getCheckedChannels().stream().filter(SenderFilmlistLoadApprover::isApproved).toList();
    }

    protected boolean seenCheck(DatenFilm film) {
        return !this.historyController.hasBeenSeenFromCache(film);
    }

    protected void calculateFilmLengthSliderValues() {
        this.minLengthInSeconds = TimeUnit.SECONDS.convert((long)this.filterConfiguration.getFilmLengthMin(), TimeUnit.MINUTES);
        this.maxLengthInSeconds = TimeUnit.SECONDS.convert((long)this.filterConfiguration.getFilmLengthMax(), TimeUnit.MINUTES);
    }
}

