#!/bin/bash

# SPDX-FileCopyrightText: Copyright (c) 2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved. 
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction, 
# disclosure or distribution of this material and related documentation 
# without an express license agreement from NVIDIA CORPORATION or 
# its affiliates is strictly prohibited.

if [ "${BASH_SOURCE[0]}" == "${0}" ]; then
    echo "Error: This script needs to be sourced. Please run as 'source ${BASH_SOURCE[0]} install-directory-param'" >&2
    exit 1
fi

if [ -z "$1" ]; then
    echo "Error: This script needs to be called with install directory parameter.\
        Please run as 'source ${BASH_SOURCE[0]} install-directory-param'" >&2
    exit 1
fi

install_dir=$1
script_dir=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")" &>/dev/null && pwd)

# shellcheck source=/dev/null
source "$script_dir/setup-dependencies-environment.sh" "$install_dir"

if grep -qs "debian" /etc/os-release 2>/dev/null; then
    # shellcheck source=/dev/null
    source "$script_dir"/Debian/non-root-dependencies-installer-debian.sh "$install_dir"
elif [[ -f /etc/redhat-release ]]; then
    # shellcheck source=/dev/null
    source "$script_dir"/RHEL/non-root-dependencies-installer-rhel.sh "$install_dir"
else
    echo "Unsupported OS for non-root dependencies installer." >/dev/tty
fi
