from typing import List, Optional

from pydantic import BaseModel

from .cpu_info import CpuInfoInDB, CpuInfoCreate
from .health_check import HealthCheckInDB, HealthCheckCreate
from .process_utilization import ProcessUtilisationInDB, ProcessUtilisationCreate
from .application_stats import ApplicationStatsInDB, ApplicationStatsCreate
from .thread_concurrency import ThreadConcurrencyInDB, ThreadConcurrencyCreate
from .thread_time import ThreadTimeInDB, ThreadTimeCreate


class ThreadingAnalysisInDB(BaseModel):
    application_stats: Optional[ApplicationStatsInDB]
    cpu_info: Optional[CpuInfoInDB]
    health_check: List[HealthCheckInDB]
    process_utilisation: List[ProcessUtilisationInDB]
    thread_concurrency: List[ThreadConcurrencyInDB]
    thread_time: List[ThreadTimeInDB]

    class Config:
        from_attributes = True


class ThreadingAnalysisCreate(BaseModel):
    report_id: int
    application_stats: ApplicationStatsCreate
    cpu_info: CpuInfoCreate
    health_check: List[HealthCheckCreate]
    process_utilisation: List[ProcessUtilisationCreate]
    thread_concurrency: List[ThreadConcurrencyCreate]
    thread_time: List[ThreadTimeCreate]

    class Config:
        from_attributes = True
