/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableBufferImpl;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.MapNonNativeWritableBufferImpl;
import com.yahoo.memory.MapNonNativeWritableMemoryImpl;
import com.yahoo.memory.MapWritableBufferImpl;
import com.yahoo.memory.StepBoolean;
import com.yahoo.memory.Util;
import com.yahoo.memory.WritableMemoryImpl;
import java.nio.ByteOrder;

final class MapWritableMemoryImpl
extends WritableMemoryImpl {
    private static final int id = 16;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private final byte typeId;

    MapWritableMemoryImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.typeId = (byte)(0x10 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return Util.isNativeOrder(byteOrder) ? new MapWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid) : new MapNonNativeWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | (readOnly ? (byte)1 : 0);
        return Util.isNativeOrder(byteOrder) ? new MapWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this) : new MapNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this);
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

