/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.summarization;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Center
implements ICluster<float[]> {
    float[] representative;
    double weight;
    ArrayList<Weighted<Integer>> assignedPoints;
    double sumOfRadius;
    double previousWeight = 0.0;
    double previousSumOFRadius = 0.0;

    Center(float[] coordinate, float weight) {
        this.representative = Arrays.copyOf(coordinate, coordinate.length);
        this.weight = weight;
        this.assignedPoints = new ArrayList();
    }

    public static Center initialize(float[] coordinate, float weight) {
        return new Center(coordinate, weight);
    }

    @Override
    public void addPoint(int index, float weight, double dist, float[] point, BiFunction<float[], float[], Double> distance) {
        this.assignedPoints.add(new Weighted<Integer>(index, weight));
        this.weight += (double)weight;
        this.sumOfRadius += (double)weight * dist;
    }

    @Override
    public void reset() {
        this.assignedPoints = new ArrayList();
        this.previousWeight = this.weight;
        this.weight = 0.0;
        this.previousSumOFRadius = this.sumOfRadius;
    }

    @Override
    public double averageRadius() {
        return this.weight > 0.0 ? this.sumOfRadius / this.weight : 0.0;
    }

    @Override
    public double extentMeasure() {
        return this.weight > 0.0 ? this.sumOfRadius / this.weight : 0.0;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public double recompute(Function<Integer, float[]> getPoint, boolean approx, BiFunction<float[], float[], Double> distance) {
        if (this.assignedPoints.size() == 0 || this.weight == 0.0) {
            Arrays.fill(this.representative, 0.0f);
            return 0.0;
        }
        this.previousSumOFRadius = this.sumOfRadius;
        this.sumOfRadius = 0.0;
        for (int i = 0; i < this.representative.length; ++i) {
            int position;
            int index = i;
            this.assignedPoints.sort((o1, o2) -> Double.compare(((float[])getPoint.apply((Integer)o1.index))[index], ((float[])getPoint.apply((Integer)o2.index))[index]));
            double runningWeight = this.weight / 2.0;
            for (position = 0; runningWeight >= 0.0 && position < this.assignedPoints.size() && runningWeight > (double)this.assignedPoints.get((int)position).weight; runningWeight -= (double)this.assignedPoints.get((int)position).weight, ++position) {
            }
            if (position == this.assignedPoints.size()) {
                --position;
            }
            this.representative[index] = getPoint.apply((Integer)this.assignedPoints.get((int)position).index)[index];
        }
        for (int j = 0; j < this.assignedPoints.size(); ++j) {
            double addTerm = distance.apply(this.representative, getPoint.apply((Integer)this.assignedPoints.get((int)j).index)) * (double)this.assignedPoints.get((int)j).weight;
            CommonUtils.checkArgument(addTerm >= 0.0, "distances or weights cannot be negative");
            this.sumOfRadius += addTerm;
        }
        return this.previousSumOFRadius - this.sumOfRadius;
    }

    @Override
    public List<Weighted<Integer>> getAssignedPoints() {
        return this.assignedPoints;
    }

    @Override
    public void absorb(ICluster<float[]> other, BiFunction<float[], float[], Double> distance) {
        List<Weighted<float[]>> representatives = other.getRepresentatives();
        float[] closest = (float[])representatives.get((int)0).index;
        double dist = Double.MAX_VALUE;
        for (Weighted<float[]> e : representatives) {
            double t = distance.apply((float[])e.index, this.representative);
            CommonUtils.checkArgument(t >= 0.0, "distances cannot be negative");
            if (!(t < dist)) continue;
            dist = t;
            closest = (float[])e.index;
        }
        double otherWeight = other.getWeight();
        double expRatio = Math.exp(2.0 * (this.weight - otherWeight) / (this.weight + otherWeight));
        double factor = expRatio / (1.0 + expRatio);
        for (int i = 0; i < this.representative.length; ++i) {
            this.representative[i] = (float)(factor * (double)this.representative[i] + (1.0 - factor) * (double)closest[i]);
        }
        this.sumOfRadius += (this.weight * (1.0 - factor) + otherWeight * factor) * dist;
        this.weight += otherWeight;
        this.assignedPoints.addAll(other.getAssignedPoints());
        other.reset();
    }

    @Override
    public double distance(float[] point, BiFunction<float[], float[], Double> distance) {
        double t = distance.apply(point, this.representative);
        CommonUtils.checkArgument(t >= 0.0, "distance cannot be negative");
        return t;
    }

    @Override
    public double distance(ICluster<float[]> other, BiFunction<float[], float[], Double> distance) {
        return other.distance(this.representative, distance);
    }

    @Override
    public float[] primaryRepresentative(BiFunction<float[], float[], Double> distance) {
        return Arrays.copyOf(this.representative, this.representative.length);
    }

    @Override
    public List<Weighted<float[]>> getRepresentatives() {
        ArrayList<Weighted<float[]>> answer = new ArrayList<Weighted<float[]>>();
        answer.add(new Weighted<float[]>(this.representative, (float)this.weight));
        return answer;
    }
}

