# Logs and Statistics

## Logs

To monitor the OvenMediaEngine, you can view in real-time the log files generated by itself. You can configure a log type and level by creating the `Logger.xml` configuration file in the same location as Server.xml.

You can set up Logger.xml as shown in the following example: OvenMediaEngine prints logs separated by many tag names and levels. Set `<Tag name=".*" level="debug">` to have OvenMediaEngine print all logs and read the logs. And then it's better to disable tags that you don't need.

```markup
<Logger version="2">
	<!-- Log file location -->
	<Path>/var/log/ovenmediaengine</Path>

	<!-- Disable some SRT internal logs -->
	<Tag name="SRT" level="critical" />
	<Tag name="Monitor" level="critical" />

	<!-- Log level: [debug, info, warn, error, critical] -->
	<Tag name=".*" level="info" />
</Logger>

```

OvenMediaEngine generates log files. If you start OvenMediaEngine by `systemctl start ovenmediaengine`, the log file is generated to the following path.

```bash
/var/log/ovenmediaengine
```

If you run it directly from the command line, it will be generated to the following location:&#x20;

```bash
/<OvenMediaEngine Binary Path>/log/
```

If you run it in the Docker container, the log file is in the following path:

```markup
# For Origin mode
/opt/ovenmediaengine/bin/log/
# For Edge mode
/opt/ovenmediaengine/bin/log/
```

Following is the example of real logs.&#x20;

```markup
getroot@Jeheon-Main:/var/log/ovenmediaengine$ cat ovenmediaengine.log
[03-27 19:59:13.221] I 10996 Config | config_manager.cpp:144  | Trying to set logfile in directory... (/var/log/ovenmediaengine)
[03-27 19:59:13.221] I 10996 Config | config_manager.cpp:47   | Trying to load configurations... (origin_conf/Server.xml)
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:211  | OvenMediaEngine v0.9.5 (v0.9.1-422-g6e4b7ce) is started on [Jeheon-Main] (Linux x86_64 - 4.4.0-18362-Microsoft, #476-Microsoft Fri Nov 01 16:53:00 PST 2019)
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:213  | With modules:
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:214  |   FFmpeg 3.4.2
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:215  |     Configuration: --prefix=/opt/ovenmediaengine --enable-gpl --enable-nonfree --extra-cflags=-I/opt/ovenmediaengine/include --extra-ldflags='-L/opt/ovenmediaengine/lib -Wl,-rpath,/opt/ovenmediaengine/lib' --extra-libs=-ldl --enable-shared --disable-static --disable-debug --disable-doc --disable-programs --disable-avdevice --disable-dct --disable-dwt --disable-error-resilience --disable-lsp --disable-lzo --disable-rdft --disable-faan --disable-pixelutils --disable-everything --enable-zlib --enable-libopus --enable-libvpx --enable-libfdk_aac --enable-libx264 --enable-encoder='libvpx_vp8,libvpx_vp9,libopus,libfdk_aac,libx264' --enable-decoder='aac,aac_latm,aac_fixed,h264' --enable-parser='aac,aac_latm,aac_fixed,h264' --enable-network --enable-protocol=tcp --enable-protocol=udp --enable-protocol=rtp --enable-demuxer=rtsp --enable-filter='asetnsamples,aresample,aformat,channelmap,channelsplit,scale,transpose,fps,settb,asettb'
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:216  |     libavformat: 57.83.100
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:217  |     libavcodec: 57.107.100
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:218  |     libavutil: 55.78.100
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:219  |     libavfilter: 6.107.100
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:220  |     libswresample: 2.9.100
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:221  |     libswscale: 4.8.100
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:222  |   SRT: 1.3.3
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:223  |   SRTP: libsrtp2 2.2.0
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:224  |   OpenSSL: OpenSSL 1.1.0g  2 Nov 2017
[03-27 19:59:13.235] I 10996 OvenMediaEngine | main.cpp:225  |     Configuration: compiler: gcc -DDSO_DLFCN -DHAVE_DLFCN_H -DNDEBUG -DOPENSSL_THREADS -DOPENSSL_NO_STATIC_ENGINE -DOPENSSL_PIC -DOPENSSL_IA32_SSE2 -DOPENSSL_BN_ASM_MONT -DOPENSSL_BN_ASM_MONT5 -DOPENSSL_BN_ASM_GF2m -DSHA1_ASM -DSHA256_ASM -DSHA512_ASM -DRC4_ASM -DMD5_ASM -DAES_ASM -DVPAES_ASM -DBSAES_ASM -DGHASH_ASM -DECP_NISTZ256_ASM -DPADLOCK_ASM -DPOLY1305_ASM -DOPENSSLDIR="\"/opt/ovenmediaengine\"" -DENGINESDIR="\"/opt/ovenmediaengine/lib/engines-1.1\""  -Wa,--noexecstack
[03-27 19:59:13.240] I 10996 Monitor | monitoring.cpp:35   | Create HostMetrics(default) for monitoring
[03-27 19:59:13.240] I 10996 OvenMediaEngine | main.cpp:148  | Trying to create a module MediaRouter for [default] host...
[03-27 19:59:13.240] I 10996 MediaRouter | media_router.cpp:40   | MediaRouter has been started.
[03-27 19:59:13.240] I 10996 OvenMediaEngine | main.cpp:151  | Trying to create a module RTMP Provider for [default] host...
[03-27 19:59:13.244] I 10996 RtmpProvider | rtmp_provider.cpp:63   | RTMP Server has started listening on 0.0.0.0:1935...
[03-27 19:59:13.246] I 10996 Provider | provider.cpp:40   | RtmpProvider has been started.
[03-27 19:59:13.246] I 10996 OvenMediaEngine | main.cpp:152  | Trying to create a module OVT Provider for [default] host...
[03-27 19:59:13.248] I 10996 Provider | provider.cpp:40   | OvtProvider has been started.
[03-27 19:59:13.248] I 10996 OvenMediaEngine | main.cpp:153  | Trying to create a module RTSPC Provider for [default] host...
[03-27 19:59:13.250] I 10996 Provider | provider.cpp:40   | RtspcProvider has been started.
[03-27 19:59:13.250] I 10996 OvenMediaEngine | main.cpp:154  | Trying to create a module RTSP Provider for [default] host...
[03-27 19:59:13.250] I 10996 RtspProvider | rtsp_provider.cpp:40   | RTSP is disabled in the configuration.
[03-27 19:59:13.251] I 10996 OvenMediaEngine | main.cpp:157  | Trying to create a module Transcoder for [default] host...
[03-27 19:59:13.251] I 10996 Transcoder | transcoder.cpp:38   | Transcoder has been started.
[03-27 19:59:13.251] I 10996 OvenMediaEngine | main.cpp:160  | Trying to create a module WebRTC Publisher for [default] host...
[03-27 19:59:13.251] I 10996 Signalling | rtc_signalling_server.cpp:74   | P2P is disabled in the configuration
[03-27 19:59:13.258] I 10996 Ice | ice_port.cpp:89   | ICE port is bound to 0.0.0.0:10000/UDP
[03-27 19:59:13.260] I 10996 Ice | ice_port.cpp:89   | ICE port is bound to 0.0.0.0:10001/UDP
[03-27 19:59:13.261] I 10996 Ice | ice_port.cpp:89   | ICE port is bound to 0.0.0.0:10002/UDP
[03-27 19:59:13.263] I 10996 Ice | ice_port.cpp:89   | ICE port is bound to 0.0.0.0:10003/UDP
[03-27 19:59:13.264] I 10996 Ice | ice_port.cpp:89   | ICE port is bound to 0.0.0.0:10004/UDP
[03-27 19:59:13.266] I 10996 Ice | ice_port.cpp:89   | ICE port is bound to 0.0.0.0:10005/UDP
[03-27 19:59:13.266] I 10996 Publisher | publisher.cpp:15   | WebRTC Publisher has been started.
[03-27 19:59:13.266] I 10996 WebRTC | webrtc_publisher.cpp:89   | WebRTC Publisher has started listening on 0.0.0.0:3333...
[03-27 19:59:13.266] I 10996 Publisher | publisher.cpp:15   | WebRTC Publisher has been started.
[03-27 19:59:13.266] I 10996 OvenMediaEngine | main.cpp:161  | Trying to create a module HLS Publisher for [default] host...
[03-27 19:59:13.273] I 10996 Publisher | segment_publisher.cpp:65   | HLS Publisher has started listening on 0.0.0.0:8080...
[03-27 19:59:13.273] I 10996 Publisher | publisher.cpp:15   | HLS Publisher has been started.
[03-27 19:59:13.275] I 10996 OvenMediaEngine | main.cpp:162  | Trying to create a module MPEG-DASH Publisher for [default] host...
[03-27 19:59:13.281] I 10996 Publisher | segment_publisher.cpp:65   | DASH Publisher has started listening on 0.0.0.0:8080...
[03-27 19:59:13.281] I 10996 Publisher | publisher.cpp:15   | DASH Publisher has been started.
[03-27 19:59:13.282] I 10996 OvenMediaEngine | main.cpp:163  | Trying to create a module Low-Latency MPEG-DASH Publisher for [default] host...
[03-27 19:59:13.289] I 10996 Publisher | segment_publisher.cpp:65   | LLDASH Publisher has started listening on 0.0.0.0:8080...
[03-27 19:59:13.289] I 10996 Publisher | publisher.cpp:15   | LLDASH Publisher has been started.
[03-27 19:59:13.291] I 10996 OvenMediaEngine | main.cpp:164  | Trying to create a module OVT Publisher for [default] host...
[03-27 19:59:13.294] I 10996 OVT | ovt_publisher.cpp:49   | Ovt Publisher has started listening on 0.0.0.0:9000
[03-27 19:59:13.294] I 10996 Publisher | publisher.cpp:15   | OVTPublisher has been started.
[03-27 19:59:13.294] I 10996 OvenMediaEngine | main.cpp:169  | All modules are initialized successfully
[03-27 19:59:13.294] I 10996 Orchestrator | orchestrator.cpp:856  | Trying to create an application: [#default#app]
[03-27 19:59:13.294] I 10996 Monitor | host_metrics.cpp:52   | Create ApplicationMetrics(#default#app) for monitoring
[03-27 19:59:13.297] I 10996 Provider | application.cpp:30   | [#default#app] RTMP Provider application has been started
[03-27 19:59:13.297] I 10996 Provider | application.cpp:30   | [#default#app] OVT Provider application has been started
[03-27 19:59:13.297] I 10996 Provider | application.cpp:30   | [#default#app] RTSP Pull Provider application has been started
[03-27 19:59:13.297] I 10996 Provider | application.cpp:30   | [#default#app] RTSP Provider application has been started
[03-27 19:59:13.298] I 10996 TranscodeApplication | transcode_application.cpp:36   | [#default#app] Transcoder Application has been started
[03-27 19:59:13.300] I 10996 Publisher | application.cpp:26   | [#default#app] WebRTC Publisher application has been started
[03-27 19:59:13.302] I 10996 Publisher | application.cpp:26   | [#default#app] HLS Publisher application has been started
[03-27 19:59:13.304] I 10996 Publisher | application.cpp:26   | [#default#app] DASH Publisher application has been started
[03-27 19:59:13.305] I 10996 Publisher | application.cpp:26   | [#default#app] LLDASH Publisher application has been started
[03-27 19:59:13.307] I 10996 Publisher | application.cpp:26   | [#default#app] OVT Publisher application has been started
[03-27 19:59:14.706] I 11002 RtmpProvider | rtmp_server.cpp:126  | A RTMP client has connected from <ClientSocket: 0x7fffd4000b70, #24, state: 4, TCP, 192.168.0.200:11031>
[03-27 19:59:14.835] I 11002 RtmpProvider | rtmp_server.cpp:226  | [#default#app/stream] RTMP Provider stream has been created: id(0/0) device(OBS) remote(<ClientSocket: 0x7fffd4000b70, #24, state: 4, TCP, 192.168.0.200:11031>)
[03-27 19:59:14.835] I 11002 MediaRouter.App | media_route_application.cpp:184  | Trying to create a stream: [#default#app/stream(2921228900)]
[03-27 19:59:14.836] I 11002 Monitor | stream.cpp:240  | 
[Stream Info]
id(2921228900), name(stream), SourceType(Rtmp), Created Time (Fri Mar 27 19:59:14 2020)

        Video Track #0: Bypass(false) Bitrate(2.50Mb) codec(1, avc) resolution(1280x720) framerate(30.00fps) timebase(1/90000)
        Audio Track #1: Bypass(false) Bitrate(160.00Kb) codec(5, aac) samplerate(44.1K) format(s16, 16) channel(stereo, 2) timebase(1/44100)
[03-27 19:59:14.836] I 11002 Monitor | application_metrics.cpp:56   | Create StreamMetrics(stream) for monitoring
[03-27 19:59:14.836] I 11002 TranscodeStream | transcode_stream.cpp:353  | [#default#app/stream(2921228900)] -> [#default#app/stream_medium_o(3169746412)] Transcoder output stream has been created.
[03-27 19:59:14.839] I 11002 FFmpeg | third_parties.cpp:115  |  [AVCodecContext] using SAR=1/1
[03-27 19:59:14.841] I 11002 FFmpeg | third_parties.cpp:115  |  [AVCodecContext] using cpu capabilities: MMX2 SSE2Fast SSSE3 SSE4.2 AVX FMA3 BMI2 AVX2
[03-27 19:59:14.846] I 11002 FFmpeg | third_parties.cpp:115  |  [AVCodecContext] profile Constrained Baseline, level 3.0, 4:2:0, 8-bit
[03-27 19:59:14.849] I 11002 FFmpeg | third_parties.cpp:115  |  [AVCodecContext] v1.7.0
[03-27 19:59:14.864] I 11048 MediaRouter.App | media_route_application.cpp:184  | Trying to create a stream: [#default#app/stream_medium_o(3169746412)]
[03-27 19:59:14.864] I 11002 TranscodeStream | transcode_stream.cpp:108  | [#default#app/stream(2921228900)] Transcoder input stream has been started. Status : (2) Decoders, (4) Encoders
[03-27 19:59:14.865] I 11048 Monitor | stream.cpp:240  | 
[Stream Info]
id(3169746412), name(stream_medium_o), SourceType(Transcoder), Created Time (Fri Mar 27 19:59:14 2020)
        >> Origin Stream Info
        id(2921228900), name(stream), SourceType(Rtmp), Created Time (Fri Mar 27 19:59:14 2020)

        Video Track #0: Bypass(false) Bitrate(700.00Kb) codec(2, vp8) resolution(640x360) framerate(30.00fps) timebase(1/90000)
        Video Track #1: Bypass(false) Bitrate(700.00Kb) codec(1, avc) resolution(640x360) framerate(30.00fps) timebase(1/90000)
        Audio Track #2: Bypass(false) Bitrate(48.00Kb) codec(7, opus) samplerate(48.0K) format(s16, 16) channel(stereo, 2) timebase(1/48000)
        Audio Track #3: Bypass(false) Bitrate(48.00Kb) codec(5, aac) samplerate(48.0K) format(s16, 16) channel(stereo, 2) timebase(1/48000)
[03-27 19:59:14.865] I 11048 Monitor | application_metrics.cpp:56   | Create StreamMetrics(stream_medium_o) for monitoring
[03-27 19:59:14.865] I 11048 WebRTC | rtc_stream.cpp:181  | Unsupported codec(Audio/AAC) is being input from media track
[03-27 19:59:14.880] I 11048 Publisher | stream.cpp:192  | [stream_medium_o(3169746412)] WebRTC Publisher stream has been started
[03-27 19:59:14.881] I 11048 Publisher | stream.cpp:192  | [stream_medium_o(3169746412)] HLS Publisher stream has been started
[03-27 19:59:14.881] I 11048 Publisher | stream.cpp:192  | [stream_medium_o(3169746412)] DASH Publisher stream has been started
[03-27 19:59:14.881] I 11048 Publisher | stream.cpp:192  | [stream_medium_o(3169746412)] LLDASH Publisher stream has been started
[03-27 19:59:14.897] I 11048 Publisher | stream.cpp:192  | [stream_medium_o(3169746412)] OVT Publisher stream has been started
[03-27 19:59:14.898] I 11048 TranscodeCodec | transcode_codec_dec_aac.cpp:49   | [#default#app/stream(2921228900)] input stream information: [audio] aac (LC), 44100 Hz, stereo, fltp, 154 kbps, timebase: 1/44100, frame_size: 1024
[03-27 19:59:14.985] I 11048 TranscodeCodec | transcode_codec_dec_avc.cpp:48   | [#default#app/stream(2921228900)] input stream information: [video] h264 (Constrained Baseline 3.1), yuv420p, 1280x720 [SAR 0:1 DAR 16:9], 30 fps, 195 kbps, timebase: 1/60, frame_size: 0
```

## Statistics

OvenMediaEngine collects the following metrics for each host, application, and stream.&#x20;

* Bytes in/out by protocol
* Connections by protocol
* Maximum connections and time
* Time is taken to connect to origin

You can get the current statistics using the REST API. See [Stat API ](rest-api/v1/statistics/current.md)for the statistics REST API.

{% hint style="warning" %}
Files such as webrtc\_stat.log and hls\_rtsp\_xxxx.log that were previously output are deprecated in the current version. We are developing a formal stats file, which will be open in the future.
{% endhint %}
