/*
 *  Phusion Passenger - https://www.phusionpassenger.com/
 *  Copyright (c) 2017-2025 Asynchronous B.V.
 *
 *  "Passenger", "Phusion Passenger" and "Union Station" are registered
 *  trademarks of Asynchronous B.V.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

/*
 * SpawningKit/Result/AutoGeneratedCode.h is automatically generated from
 * SpawningKit/Result/AutoGeneratedCode.h.cxxcodebuilder by the build system.
 * It uses the comment hints from SpawningKit/Result.h.
 *
 * To force regenerating this file:
 *   rm -f src/agent/Core/SpawningKit/Result/AutoGeneratedCode.h
 *   rake src/agent/Core/SpawningKit/Result/AutoGeneratedCode.h
 */

inline void
Passenger::SpawningKit::Result::validate_autoGeneratedCode(vector<StaticString> &internalFieldErrors, vector<StaticString> &appSuppliedFieldErrors) const {
	const Result &result = *this;

	if (OXT_UNLIKELY(!(result.pid != -1))) {
		internalFieldErrors.push_back(P_STATIC_STRING("pid is not valid"));
	}
	if (OXT_UNLIKELY(gupid.empty())) {
		internalFieldErrors.push_back(P_STATIC_STRING("gupid may not be empty"));
	}
	if (OXT_UNLIKELY(!(result.spawnStartTime != 0))) {
		internalFieldErrors.push_back(P_STATIC_STRING("spawn_start_time is not valid"));
	}
	if (OXT_UNLIKELY(!(result.spawnEndTime != 0))) {
		internalFieldErrors.push_back(P_STATIC_STRING("spawn_end_time is not valid"));
	}
	if (OXT_UNLIKELY(!(result.spawnStartTimeMonotonic != 0))) {
		internalFieldErrors.push_back(P_STATIC_STRING("spawn_start_time_monotonic is not valid"));
	}
	if (OXT_UNLIKELY(!(result.spawnEndTimeMonotonic != 0))) {
		internalFieldErrors.push_back(P_STATIC_STRING("spawn_end_time_monotonic is not valid"));
	}

	/*
	 * Excluded:
	 *
	 * type
	 * codeRevision
	 * stdinFd
	 * stdoutAndErrFd
	 */
}

