/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.AtomicParser;
import com.plantuml.ubrex.Capture;
import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.TextNavigator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeList
implements Challenge {
    private final List<Challenge> challenges = new ArrayList<Challenge>();

    public void addChallenge(Challenge p) {
        this.challenges.add(p);
    }

    public static CompositeList createEmpty() {
        return new CompositeList();
    }

    public static CompositeList parseAndBuild(CharSequence input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        return new CompositeList(input);
    }

    public String toString() {
        return this.challenges.toString();
    }

    private CompositeList() {
    }

    public static CompositeList parseAndBuildFromTextNavigator(TextNavigator input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        CompositeList result = new CompositeList();
        result.parseAndConsumeNow(input);
        return result;
    }

    private CompositeList(CharSequence definition) {
        if (definition.length() == 0) {
            throw new UnsupportedOperationException();
        }
        TextNavigator input = TextNavigator.build(definition);
        this.parseAndConsumeNow(input);
    }

    private void parseAndConsumeNow(TextNavigator input) {
        AtomicParser builder = new AtomicParser();
        while (input.length() > 0) {
            char ch = input.charAt(0);
            if (ch == ' ') {
                input.jump(1);
                continue;
            }
            for (Challenge c : builder.parse(input)) {
                this.addChallenge(c);
            }
        }
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        Capture capture = Capture.EMPTY;
        int current = position;
        for (Challenge challenge : this.challenges) {
            ChallengeResult shallWePass = challenge.runChallenge(string, current);
            if (shallWePass.getFullCaptureLength() < 0) {
                return new ChallengeResult(Integer.MIN_VALUE, capture);
            }
            current += shallWePass.getFullCaptureLength();
            capture = capture.merge(shallWePass.getCapture());
            capture = capture.merge(shallWePass.getNonMergeableCapture());
        }
        return new ChallengeResult(current - position, capture);
    }

    public List<Challenge> getInternalChallengesList() {
        return Collections.unmodifiableList(this.challenges);
    }
}

