/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.html5;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.html5.Html5Drawer;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class DriverRectangleHtml5
implements UDriver<URectangle, Html5Drawer> {
    private final ClipContainer clipContainer;

    public DriverRectangleHtml5(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, Html5Drawer html) {
        double width = rect.getWidth();
        double height = rect.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double r = clip.getClippedRectangle(new Rectangle2D.Double(x, y, width, height));
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
        }
        double rx = rect.getRx();
        double ry = rect.getRy();
        HColor back = param.getBackcolor();
        if (!(back instanceof HColorGradient)) {
            String color = param.getColor() == null ? null : param.getColor().toRGB(mapper);
            String backcolor = param.getColor() == null ? null : param.getBackcolor().toRGB(mapper);
            html.setStrokeColor(color);
            html.setFillColor(backcolor);
            html.htmlRectangle(x, y, width, height, rx / 2.0, ry / 2.0);
        }
    }
}

