/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinSimple;

public class TextBlockTitle
implements TextBlock {
    private final double outMargin = 2.0;
    private final TextBlock textBlock;

    TextBlockTitle(FontConfiguration font, Display stringsToDisplay, ISkinSimple spriteContainer) {
        if (stringsToDisplay.size() == 1 && stringsToDisplay.get(0).length() == 0) {
            throw new IllegalArgumentException();
        }
        LineBreakStrategy lineBreak = LineBreakStrategy.NONE;
        this.textBlock = stringsToDisplay.create0(font, HorizontalAlignment.CENTER, spriteContainer, lineBreak, CreoleMode.FULL, null, null);
    }

    @Override
    public final void drawU(UGraphic ug) {
        this.textBlock.drawU(ug.apply(UTranslate.dx(2.0)));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D textDim = this.textBlock.calculateDimension(stringBounder);
        double width = textDim.getWidth() + 4.0;
        double height = textDim.getHeight();
        return new XDimension2D(width, height);
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        return null;
    }

    @Override
    public MagneticBorder getMagneticBorder() {
        return new MagneticBorder(){

            @Override
            public UTranslate getForceAt(StringBounder stringBounder, XPoint2D position) {
                return TextBlockTitle.this.textBlock.getMagneticBorder().getForceAt(stringBounder, position.move(-2.0, 0.0));
            }
        };
    }

    @Override
    public HColor getBackcolor() {
        return this.textBlock.getBackcolor();
    }
}

