\name{MaskNegatedImageFilter}
\alias{MaskNegatedImageFilter}
\title{MaskNegatedImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Mask an image with the negation (or logical compliment) of a mask.
MaskNegatedImageFilter}
\details{
This class is templated over the types of the input image type, the
mask image type and the type of the output image. Numeric conversions
(castings) are done by the C++ defaults.
The pixel type of the input 2 image must have a valid definition of
the operator!=. This condition is required because internally this
filter will perform the operation
The pixel from the input 1 is cast to the pixel type of the output
image.
Note that the input and the mask images must be of the same size.
WARNING:
Only pixel value with mask_value ( defaults to 0 ) will be preserved.
See:
MaskImageFilter
MaskNegated for the procedural interface
itk::MaskNegatedImageFilter for the Doxygen on the original ITK class.
MaskNegatedImageFilter}
%C++ includes: sitkMaskNegatedImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Image &maskImage):}{}
\item{Image Execute(Image &&image, const Image &maskImage):}{
Execute the filter on the input image
}
\item{double GetMaskingValue() const:}{
Method to get the masking value of the mask.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOutsideValue() const:}{}
\item{ MaskNegatedImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetMaskingValue(double MaskingValue):}{
Method to explicitly set the masking value of the mask. Defaults to 0
}
\item{Self SetOutsideValue(double OutsideValue):}{
Method to explicitly set the outside value of the mask. Defaults to 0
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MaskNegatedImageFilter():}{
Destructor
}
}
}
