/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Pair;
import org.apache.solr.packagemanager.PackageManager;
import org.apache.solr.packagemanager.PackageUtils;
import org.apache.solr.packagemanager.RepositoryManager;
import org.apache.solr.packagemanager.SolrPackage;
import org.apache.solr.packagemanager.SolrPackageInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String solrUrl = null;
    public static String solrBaseUrl = null;
    public PackageManager packageManager;
    public RepositoryManager repositoryManager;

    public PackageTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public String getName() {
        return "package";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @SuppressForbidden(reason="We really need to print the stacktrace here, otherwise there shall be little else information to debug problems. Other SolrCLI tools don't print stack traces, hence special treatment is needed here.Need to turn off logging, and SLF4J doesn't seem to provide for a way.")
    public void runImpl(CommandLine cli) throws Exception {
        oldLevel = LoggerContext.getContext((boolean)false).getRootLogger().getLevel();
        Configurator.setRootLevel((Level)Level.OFF);
        try {
            solrUrl = cli.hasOption("solr-url") != false ? cli.getOptionValue("solr-url") : SolrCLI.getOptionWithDeprecatedAndDefault(cli, "solrUrl", "url", SolrCLI.getDefaultSolrUrl());
            PackageTool.solrBaseUrl = solrUrl.replaceAll("/solr$", "");
            PackageTool.log.debug("Solr url:{}, solr base url: {}", (Object)solrUrl, (Object)PackageTool.solrBaseUrl);
            zkHost = SolrCLI.getZkHost(cli);
            if (zkHost == null) {
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Package manager runs only in SolrCloud");
            }
            PackageTool.log.info("ZK: {}", (Object)zkHost);
            cmd = cli.getArgs()[0];
            solrClient = new Http2SolrClient.Builder(PackageTool.solrBaseUrl).build();
            try {
                this.packageManager = new PackageManager(this.runtime, (SolrClient)solrClient, solrUrl, zkHost);
                try {
                    this.repositoryManager = new RepositoryManager((SolrClient)solrClient, this.packageManager);
                    var7_8 = cmd;
                    var8_10 = -1;
                    switch (var7_8.hashCode()) {
                        case -1282064098: {
                            if (!var7_8.equals("add-repo")) break;
                            var8_10 = 0;
                            break;
                        }
                        case -1149742285: {
                            if (!var7_8.equals("add-key")) break;
                            var8_10 = 1;
                            break;
                        }
                        case -60744437: {
                            if (!var7_8.equals("list-installed")) break;
                            var8_10 = 2;
                            break;
                        }
                        case -823693222: {
                            if (!var7_8.equals("list-available")) break;
                            var8_10 = 3;
                            break;
                        }
                        case -1556184043: {
                            if (!var7_8.equals("list-deployed")) break;
                            var8_10 = 4;
                            break;
                        }
                        case 1957569947: {
                            if (!var7_8.equals("install")) break;
                            var8_10 = 5;
                            break;
                        }
                        case -1335332633: {
                            if (!var7_8.equals("deploy")) break;
                            var8_10 = 6;
                            break;
                        }
                        case -448829248: {
                            if (!var7_8.equals("undeploy")) break;
                            var8_10 = 7;
                            break;
                        }
                        case -625596190: {
                            if (!var7_8.equals("uninstall")) break;
                            var8_10 = 8;
                        }
                    }
                    switch (var8_10) {
                        case 0: {
                            repoName = cli.getArgs()[1];
                            repoUrl = cli.getArgs()[2];
                            this.repositoryManager.addRepository(repoName, repoUrl);
                            SolrCLI.printGreen("Added repository: " + repoName);
                            ** break;
lbl62:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            keyFilename = cli.getArgs()[1];
                            path = Path.of(keyFilename, new String[0]);
                            this.repositoryManager.addKey(Files.readAllBytes(path), path.getFileName().toString());
                            ** break;
lbl68:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            SolrCLI.printGreen("Installed packages:\n-----");
                            for (SolrPackageInstance pkg : this.packageManager.fetchInstalledPackageInstances()) {
                                SolrCLI.printGreen(pkg);
                            }
                            break;
                        }
                        case 3: {
                            SolrCLI.printGreen("Available packages:\n-----");
                            for (SolrPackage pkg : this.repositoryManager.getPackages()) {
                                SolrCLI.printGreen(pkg.name + " \t\t" + pkg.description);
                                for (SolrPackage.SolrPackageRelease version : pkg.versions) {
                                    SolrCLI.printGreen("\tVersion: " + version.version);
                                }
                            }
                            break;
                        }
                        case 4: {
                            if (cli.hasOption("collection")) {
                                collection = cli.getOptionValue("collection");
                                packages = this.packageManager.getPackagesDeployed(collection);
                                SolrCLI.printGreen("Packages deployed on " + collection + ":");
                                for (String packageName : packages.keySet()) {
                                    SolrCLI.printGreen("\t" + String.valueOf(packages.get(packageName)));
                                }
                            } else {
                                packageName = cli.getArgs()[1];
                                deployedCollections = this.packageManager.getDeployedCollections(packageName);
                                if (!deployedCollections.isEmpty()) {
                                    SolrCLI.printGreen("Collections on which package " + packageName + " was deployed:");
                                    for (String collection : deployedCollections.keySet()) {
                                        SolrCLI.printGreen("\t" + collection + "(" + packageName + ":" + deployedCollections.get(collection) + ")");
                                    }
                                } else {
                                    SolrCLI.printGreen("Package " + packageName + " not deployed on any collection.");
                                    ** break;
                                }
                            }
lbl103:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            parsedVersion = this.parsePackageVersion((String)cli.getArgList().get(1));
                            packageName = (String)parsedVersion.first();
                            version = (String)parsedVersion.second();
                            success = this.repositoryManager.install(packageName, version);
                            if (success) {
                                SolrCLI.printGreen(packageName + " installed.");
                                ** break;
lbl112:
                                // 1 sources

                            } else {
                                SolrCLI.printRed(packageName + " installation failed.");
                                ** break;
                            }
lbl115:
                            // 1 sources

                            break;
                        }
                        case 6: {
                            if (cli.hasOption("cluster") || cli.hasOption("collections")) {
                                parsedVersion = this.parsePackageVersion((String)cli.getArgList().get(1));
                                packageName = (String)parsedVersion.first();
                                version = (String)parsedVersion.second();
                                noPrompt = cli.hasOption("no-prompt");
                                isUpdate = cli.hasOption("update");
                                collections = cli.hasOption("collections") != false ? PackageUtils.validateCollections(cli.getOptionValue("collections").split(",")) : new String[]{};
                                parameters = cli.hasOption("param") != false ? cli.getOptionValues("param") : cli.getOptionValues("p");
                                this.packageManager.deploy(packageName, version, collections, cli.hasOption("cluster"), parameters, isUpdate, noPrompt);
                                ** break;
lbl127:
                                // 1 sources

                            } else {
                                SolrCLI.printRed("Either specify --cluster to deploy cluster level plugins or --collections <list-of-collections> to deploy collection level plugins");
                                ** break;
                            }
lbl130:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            if (cli.hasOption("cluster") || cli.hasOption("collections")) {
                                parsedVersion = this.parsePackageVersion((String)cli.getArgList().get(1));
                                if (parsedVersion.second() != null) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only package name expected, without a version. Actual: " + (String)cli.getArgList().get(1));
                                }
                                packageName = (String)parsedVersion.first();
                                collections = cli.hasOption("collections") != false ? PackageUtils.validateCollections(cli.getOptionValue("collections").split(",")) : new String[]{};
                                this.packageManager.undeploy(packageName, collections, cli.hasOption("cluster"));
                                ** break;
lbl140:
                                // 1 sources

                            } else {
                                SolrCLI.printRed("Either specify --cluster to undeploy cluster level plugins or --collections <list-of-collections> to undeploy collection level plugins");
                                ** break;
                            }
lbl143:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            parsedVersion = this.parsePackageVersion((String)cli.getArgList().get(1));
                            if (parsedVersion.second() == null) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Package name and version are both required. Actual: " + (String)cli.getArgList().get(1));
                            }
                            packageName = (String)parsedVersion.first();
                            version = (String)parsedVersion.second();
                            this.packageManager.uninstall(packageName, version);
                            ** break;
lbl152:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new RuntimeException("Unrecognized command: " + cmd);
                        }
                    }
                }
                finally {
                    this.packageManager.close();
                }
            }
            finally {
                if (solrClient != null) {
                    solrClient.close();
                }
            }
            PackageTool.log.info("Finished: {}", (Object)cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            Configurator.setRootLevel((Level)oldLevel);
        }
    }

    @Override
    public String getHeader() {
        StringBuilder sb = new StringBuilder();
        PackageUtils.format(sb, "Package Manager\n---------------");
        PackageUtils.formatGreen(sb, "bin/solr package add-repo <repository-name> <repository-url>");
        PackageUtils.format(sb, "Add a repository to Solr.");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package add-key <file-containing-trusted-key>");
        PackageUtils.format(sb, "Add a trusted key to Solr.");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package install <package-name>[:<version>] ");
        PackageUtils.format(sb, "Install a package into Solr. This copies over the artifacts from the repository into Solr's internal package store and sets up classloader for this package to be used.");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package deploy <package-name>[:<version>] [-y] [--update] --collections <comma-separated-collections> [-p <param1>=<val1> -p <param2>=<val2> ...] ");
        PackageUtils.format(sb, "Bootstraps a previously installed package into the specified collections. It the package accepts parameters for its setup commands, they can be specified (as per package documentation).");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package list-installed");
        PackageUtils.format(sb, "Print a list of packages installed in Solr.");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package list-available");
        PackageUtils.format(sb, "Print a list of packages available in the repositories.");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package list-deployed -c <collection>");
        PackageUtils.format(sb, "Print a list of packages deployed on a given collection.");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package list-deployed <package-name>");
        PackageUtils.format(sb, "Print a list of collections on which a given package has been deployed.");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package undeploy <package-name> --collections <comma-separated-collections>");
        PackageUtils.format(sb, "Undeploy a package from specified collection(s)");
        PackageUtils.format(sb, "");
        PackageUtils.formatGreen(sb, "bin/solr package uninstall <package-name>:<version>");
        PackageUtils.format(sb, "Uninstall an unused package with specified version from Solr. Both package name and version are required.");
        PackageUtils.format(sb, "\n");
        PackageUtils.format(sb, "Note: (a) Please add '--solr-url http://host:port' parameter if needed (usually on Windows).");
        PackageUtils.format(sb, "      (b) Please make sure that all Solr nodes are started with '-Denable.packages=true' parameter.");
        PackageUtils.format(sb, "\n");
        PackageUtils.format(sb, "List of options:");
        return sb.toString();
    }

    private Pair<String, String> parsePackageVersion(String arg) {
        String[] splits = arg.split(":");
        if (splits.length > 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid package name: " + arg + ". Didn't match the pattern: <packagename>:<version> or <packagename>");
        }
        String packageName = splits[0];
        String version = splits.length == 2 ? splits[1] : null;
        return new Pair((Object)packageName, (Object)version);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("collections").hasArg().argName("COLLECTIONS").desc("Specifies that this action should affect plugins for the given collections only, excluding cluster level plugins.").build(), Option.builder().longOpt("cluster").desc("Specifies that this action should affect cluster-level plugins only.").build(), Option.builder().longOpt("param").hasArgs().argName("PARAMS").desc("List of parameters to be used with deploy command.").build(), Option.builder((String)"p").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --param instead").get()).hasArg().argName("PARAMS").required(false).desc("List of parameters to be used with deploy command.").build(), Option.builder().longOpt("update").desc("If a deployment is an update over a previous deployment.").build(), Option.builder((String)"c").longOpt("collection").hasArg().argName("COLLECTION").desc("The collection to apply the package to, not required.").build(), Option.builder((String)"y").longOpt("no-prompt").desc("Don't prompt for input; accept all default choices, defaults to false.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }
}

