/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.solr.api.ClusterPluginsSource;
import org.apache.solr.api.NodeConfigClusterPluginsSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.logging.DeprecationLog;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.ModuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeConfig {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String nodeName;
    private final Path coreRootDirectory;
    private final String coresLocatorClass;
    private final String coreSorterClass;
    private final Path solrDataHome;
    private final Integer booleanQueryMaxClauseCount;
    private final Path configSetBaseDirectory;
    private final Set<Path> allowPaths;
    private final List<String> allowUrls;
    private final boolean hideStackTraces;
    private final String sharedLibDirectory;
    private final String modules;
    private final Set<String> hiddenSysProps;
    private final Predicate<String> hiddenSysPropPattern;
    private final PluginInfo shardHandlerFactoryConfig;
    private final UpdateShardHandlerConfig updateShardHandlerConfig;
    private final String configSetServiceClass;
    private final String coreAdminHandlerClass;
    private final Map<String, String> coreAdminHandlerActions;
    private final String collectionsAdminHandlerClass;
    private final String healthCheckHandlerClass;
    private final String infoHandlerClass;
    private final String configSetsHandlerClass;
    private final LogWatcherConfig logWatcherConfig;
    private final CloudConfig cloudConfig;
    private final Integer coreLoadThreads;
    private final int replayUpdatesThreads;
    private final int indexSearcherExecutorThreads;
    @Deprecated
    private final int transientCacheSize;
    private final boolean useSchemaCache;
    private final String managementPath;
    private final PluginInfo[] backupRepositoryPlugins;
    private final MetricsConfig metricsConfig;
    private final Map<String, CacheConfig> cachesConfig;
    private final PluginInfo tracerConfig;
    private final PluginInfo[] clusterPlugins;
    private final boolean fromZookeeper;
    private final String defaultZkHost;
    protected final Path solrHome;
    protected final SolrResourceLoader loader;
    protected final Properties solrProperties;
    public static final String REDACTED_SYS_PROP_VALUE = "--REDACTED--";

    private NodeConfig(String nodeName, Path coreRootDirectory, String coresLocatorClass, String coreSorterClass, Path solrDataHome, Integer booleanQueryMaxClauseCount, Path configSetBaseDirectory, String sharedLibDirectory, PluginInfo shardHandlerFactoryConfig, UpdateShardHandlerConfig updateShardHandlerConfig, String coreAdminHandlerClass, Map<String, String> coreAdminHandlerActions, String collectionsAdminHandlerClass, String healthCheckHandlerClass, String infoHandlerClass, String configSetsHandlerClass, LogWatcherConfig logWatcherConfig, CloudConfig cloudConfig, Integer coreLoadThreads, int replayUpdatesThreads, int indexSearcherExecutorThreads, int transientCacheSize, boolean useSchemaCache, String managementPath, Path solrHome, SolrResourceLoader loader, Properties solrProperties, PluginInfo[] backupRepositoryPlugins, MetricsConfig metricsConfig, Map<String, CacheConfig> cachesConfig, PluginInfo tracerConfig, PluginInfo[] clusterPlugins, boolean fromZookeeper, String defaultZkHost, Set<Path> allowPaths, List<String> allowUrls, boolean hideStackTraces, String configSetServiceClass, String modules, Set<String> hiddenSysProps) {
        this.nodeName = nodeName;
        this.coreRootDirectory = coreRootDirectory;
        this.coresLocatorClass = coresLocatorClass;
        this.coreSorterClass = coreSorterClass;
        this.solrDataHome = solrDataHome;
        this.booleanQueryMaxClauseCount = booleanQueryMaxClauseCount;
        this.configSetBaseDirectory = configSetBaseDirectory;
        this.sharedLibDirectory = sharedLibDirectory;
        this.shardHandlerFactoryConfig = shardHandlerFactoryConfig;
        this.updateShardHandlerConfig = updateShardHandlerConfig;
        this.coreAdminHandlerClass = coreAdminHandlerClass;
        this.coreAdminHandlerActions = coreAdminHandlerActions;
        this.collectionsAdminHandlerClass = collectionsAdminHandlerClass;
        this.healthCheckHandlerClass = healthCheckHandlerClass;
        this.infoHandlerClass = infoHandlerClass;
        this.configSetsHandlerClass = configSetsHandlerClass;
        this.logWatcherConfig = logWatcherConfig;
        this.cloudConfig = cloudConfig;
        this.coreLoadThreads = coreLoadThreads;
        this.replayUpdatesThreads = replayUpdatesThreads;
        this.indexSearcherExecutorThreads = indexSearcherExecutorThreads;
        this.transientCacheSize = transientCacheSize;
        this.useSchemaCache = useSchemaCache;
        this.managementPath = managementPath;
        this.solrHome = solrHome;
        this.loader = loader;
        this.solrProperties = solrProperties;
        this.backupRepositoryPlugins = backupRepositoryPlugins;
        this.metricsConfig = metricsConfig;
        this.cachesConfig = cachesConfig == null ? Collections.emptyMap() : cachesConfig;
        this.tracerConfig = tracerConfig;
        this.clusterPlugins = clusterPlugins;
        this.fromZookeeper = fromZookeeper;
        this.defaultZkHost = defaultZkHost;
        this.allowPaths = allowPaths;
        this.allowUrls = allowUrls;
        this.hideStackTraces = hideStackTraces;
        this.configSetServiceClass = configSetServiceClass;
        this.modules = modules;
        this.hiddenSysProps = hiddenSysProps;
        this.hiddenSysPropPattern = Pattern.compile("^(" + String.join((CharSequence)"|", hiddenSysProps) + ")$", 2).asMatchPredicate();
        if (this.cloudConfig != null && this.getCoreLoadThreadCount(false) < 2) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCloud requires a value of at least 2 for coreLoadThreads (configured value = " + this.coreLoadThreads + ")");
        }
        if (null == this.solrHome) {
            throw new NullPointerException("solrHome");
        }
        if (null == this.loader) {
            throw new NullPointerException("loader");
        }
        if (this.clusterPlugins != null && this.clusterPlugins.length > 0 && !ClusterPluginsSource.resolveClassName().equals(NodeConfigClusterPluginsSource.class.getName())) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cluster plugins found in solr.xml but the property solr.cluster.plugin.edit.enabled is set to true. Cluster plugins may only be declared in solr.xml with immutable configs.");
        }
        this.setupSharedLib();
        this.initModules();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeConfig loadNodeConfig(Path solrHome, Properties nodeProperties) {
        if (StrUtils.isNotNullOrEmpty((String)System.getProperty("solr.solrxml.location"))) {
            log.warn("Solr property solr.solrxml.location is no longer supported. Will automatically load solr.xml from ZooKeeper if it exists");
        }
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        NodeConfig.initModules(loader, null);
        nodeProperties = SolrXmlConfig.wrapAndSetZkHostFromSysPropIfNeeded(nodeProperties);
        String zkHost = nodeProperties.getProperty("zkHost");
        if (!StrUtils.isNotNullOrEmpty((String)zkHost)) return SolrXmlConfig.fromSolrHome(solrHome, nodeProperties);
        int startUpZkTimeOut = Integer.getInteger("waitForZk", 30);
        startUpZkTimeOut *= 1000;
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(startUpZkTimeOut, TimeUnit.MILLISECONDS).withConnTimeOut(startUpZkTimeOut, TimeUnit.MILLISECONDS).withSolrClassLoader((SolrClassLoader)loader).build();){
            if (zkClient.exists("/solr.xml", true).booleanValue()) {
                log.info("solr.xml found in ZooKeeper. Loading...");
                DeprecationLog.log("solrxml-zookeeper", "Loading solr.xml from zookeeper is deprecated. See reference guide for details.");
                byte[] data = zkClient.getData("/solr.xml", null, null, true);
                NodeConfig nodeConfig = SolrXmlConfig.fromInputStream(solrHome, new ByteArrayInputStream(data), nodeProperties, true);
                return nodeConfig;
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error occurred while loading solr.xml from zookeeper", (Throwable)e);
        }
        log.info("Loading solr.xml from SolrHome (not found in ZooKeeper)");
        return SolrXmlConfig.fromSolrHome(solrHome, nodeProperties);
    }

    public String getConfigSetServiceClass() {
        return this.configSetServiceClass;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Path getCoreRootDirectory() {
        return this.coreRootDirectory;
    }

    public String getCoresLocatorClass() {
        return this.coresLocatorClass;
    }

    public String getCoreSorterClass() {
        return this.coreSorterClass;
    }

    public Path getSolrDataHome() {
        return this.solrDataHome;
    }

    public static Path getSolrInstallDir() {
        String prop = System.getProperty("solr.install.dir");
        if (prop == null || prop.isBlank()) {
            log.debug("solr.install.dir property not initialized.");
            return null;
        }
        return Paths.get(prop, new String[0]);
    }

    public Integer getBooleanQueryMaxClauseCount() {
        return this.booleanQueryMaxClauseCount;
    }

    public PluginInfo getShardHandlerFactoryPluginInfo() {
        return this.shardHandlerFactoryConfig;
    }

    public UpdateShardHandlerConfig getUpdateShardHandlerConfig() {
        return this.updateShardHandlerConfig;
    }

    public int getCoreLoadThreadCount(boolean zkAware) {
        return this.coreLoadThreads == null ? (zkAware ? 8 : 3) : this.coreLoadThreads;
    }

    public int getReplayUpdatesThreads() {
        return this.replayUpdatesThreads;
    }

    public int getIndexSearcherExecutorThreads() {
        return this.indexSearcherExecutorThreads;
    }

    public String getSharedLibDirectory() {
        return this.sharedLibDirectory;
    }

    public String getCoreAdminHandlerClass() {
        return this.coreAdminHandlerClass;
    }

    public Map<String, String> getCoreAdminHandlerActions() {
        return this.coreAdminHandlerActions;
    }

    public String getCollectionsHandlerClass() {
        return this.collectionsAdminHandlerClass;
    }

    public String getHealthCheckHandlerClass() {
        return this.healthCheckHandlerClass;
    }

    public String getInfoHandlerClass() {
        return this.infoHandlerClass;
    }

    public String getConfigSetsHandlerClass() {
        return this.configSetsHandlerClass;
    }

    public boolean hasSchemaCache() {
        return this.useSchemaCache;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public Path getConfigSetBaseDirectory() {
        return this.configSetBaseDirectory;
    }

    public LogWatcherConfig getLogWatcherConfig() {
        return this.logWatcherConfig;
    }

    public CloudConfig getCloudConfig() {
        return this.cloudConfig;
    }

    public int getTransientCacheSize() {
        return this.transientCacheSize;
    }

    public Properties getSolrProperties() {
        return this.solrProperties;
    }

    public Path getSolrHome() {
        return this.solrHome;
    }

    public SolrResourceLoader getSolrResourceLoader() {
        return this.loader;
    }

    public PluginInfo[] getBackupRepositoryPlugins() {
        return this.backupRepositoryPlugins;
    }

    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    public Map<String, CacheConfig> getCachesConfig() {
        return this.cachesConfig;
    }

    public PluginInfo getTracerConfiguratorPluginInfo() {
        return this.tracerConfig;
    }

    public PluginInfo[] getClusterPlugins() {
        return this.clusterPlugins;
    }

    public boolean isFromZookeeper() {
        return this.fromZookeeper;
    }

    public String getDefaultZkHost() {
        return this.defaultZkHost;
    }

    public Set<Path> getAllowPaths() {
        return this.allowPaths;
    }

    public List<String> getAllowUrls() {
        return this.allowUrls;
    }

    public boolean hideStackTraces() {
        return this.hideStackTraces;
    }

    private void setupSharedLib() {
        LinkedHashSet<String> libDirs = new LinkedHashSet<String>();
        libDirs.add("lib");
        Path solrInstallDir = NodeConfig.getSolrInstallDir();
        if (solrInstallDir == null) {
            log.warn("Unable to add $SOLR_HOME/lib for shared lib since {} was not set.", (Object)"solr.install.dir");
        } else {
            libDirs.add(solrInstallDir.resolve("lib").toAbsolutePath().normalize().toString());
        }
        if (StrUtils.isNotBlank((String)this.getSharedLibDirectory())) {
            List<String> sharedLibs = Arrays.asList(this.getSharedLibDirectory().split("\\s*,\\s*"));
            libDirs.addAll(sharedLibs);
        }
        this.addFoldersToSharedLib(libDirs);
    }

    public String getModules() {
        return this.modules;
    }

    public Set<String> getHiddenSysProps() {
        return this.hiddenSysProps;
    }

    public boolean isSysPropHidden(String sysPropName) {
        return this.hiddenSysPropPattern.test(sysPropName);
    }

    public String getRedactedSysPropValue(String sysPropName) {
        return this.hiddenSysPropPattern.test(sysPropName) ? REDACTED_SYS_PROP_VALUE : System.getProperty(sysPropName);
    }

    private void addFoldersToSharedLib(Set<String> libDirs) {
        boolean modified = false;
        for (String libDir : libDirs) {
            Path libPath = this.getSolrHome().resolve(libDir);
            if (!Files.exists(libPath, new LinkOption[0])) continue;
            try {
                this.loader.addToClassLoader(SolrResourceLoader.getURLs(libPath));
                modified = true;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't load libs: " + String.valueOf(e), (Throwable)e);
            }
        }
        if (modified) {
            this.loader.reloadLuceneSPI();
        }
    }

    private void initModules() {
        NodeConfig.initModules(this.loader, this.getModules());
    }

    public static void initModules(SolrResourceLoader loader, String modules) {
        Collection<String> moduleNames = ModuleUtils.resolveModulesFromStringOrSyspropOrEnv(modules);
        boolean modified = false;
        Path solrInstallDir = NodeConfig.getSolrInstallDir();
        if (solrInstallDir == null) {
            if (!moduleNames.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to setup modules " + String.valueOf(moduleNames) + " because solr.install.dir was not set.");
            }
            return;
        }
        for (String m : moduleNames) {
            if (!ModuleUtils.moduleExists(solrInstallDir, m)) {
                log.error("No module with name {}, available modules are {}", (Object)m, ModuleUtils.listAvailableModules(solrInstallDir));
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No module with name " + m);
            }
            Path moduleLibPath = ModuleUtils.getModuleLibPath(solrInstallDir, m);
            if (Files.exists(moduleLibPath, new LinkOption[0])) {
                try {
                    List<URL> urls = SolrResourceLoader.getURLs(moduleLibPath);
                    loader.addToClassLoader(urls);
                    if (log.isInfoEnabled()) {
                        log.info("Added module {}. libPath={} with {} libs", new Object[]{m, moduleLibPath, urls.size()});
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Libs loaded from {}: {}", (Object)moduleLibPath, urls);
                    }
                    modified = true;
                    continue;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't load libs for module " + m + ": " + String.valueOf(e), (Throwable)e);
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Module lib folder " + String.valueOf(moduleLibPath) + " not found.");
        }
        if (modified) {
            loader.reloadLuceneSPI();
        }
    }

    public static class NodeConfigBuilder {
        private SolrResourceLoader loader;
        private Path coreRootDirectory;
        private String coresLocatorClass = "org.apache.solr.core.CorePropertiesLocator";
        private String coreSorterClass = "org.apache.solr.core.CoreSorter";
        private Path solrDataHome;
        private Integer booleanQueryMaxClauseCount;
        private Path configSetBaseDirectory;
        private String sharedLibDirectory;
        private String modules;
        private String hiddenSysProps;
        private PluginInfo shardHandlerFactoryConfig;
        private UpdateShardHandlerConfig updateShardHandlerConfig = UpdateShardHandlerConfig.DEFAULT;
        private String configSetServiceClass;
        private String coreAdminHandlerClass = "org.apache.solr.handler.admin.CoreAdminHandler";
        private Map<String, String> coreAdminHandlerActions = Collections.emptyMap();
        private String collectionsAdminHandlerClass = "org.apache.solr.handler.admin.CollectionsHandler";
        private String healthCheckHandlerClass = "org.apache.solr.handler.admin.HealthCheckHandler";
        private String infoHandlerClass = "org.apache.solr.handler.admin.InfoHandler";
        private String configSetsHandlerClass = "org.apache.solr.handler.admin.ConfigSetsHandler";
        private LogWatcherConfig logWatcherConfig = new LogWatcherConfig(true, null, null, 50);
        private CloudConfig cloudConfig;
        private int coreLoadThreads = 3;
        private int replayUpdatesThreads = Runtime.getRuntime().availableProcessors();
        private int indexSearcherExecutorThreads = 0;
        @Deprecated
        private int transientCacheSize = -1;
        private boolean useSchemaCache = false;
        private String managementPath;
        private Properties solrProperties = new Properties();
        private PluginInfo[] backupRepositoryPlugins;
        private MetricsConfig metricsConfig;
        private Map<String, CacheConfig> cachesConfig;
        private PluginInfo tracerConfig;
        private PluginInfo[] clusterPlugins;
        private boolean fromZookeeper = false;
        private String defaultZkHost;
        private Set<Path> allowPaths = Collections.emptySet();
        private List<String> allowUrls = Collections.emptyList();
        private boolean hideStackTrace = Boolean.getBoolean("solr.hideStackTrace");
        private final Path solrHome;
        private final String nodeName;
        public static final int DEFAULT_CORE_LOAD_THREADS = 3;
        public static final int DEFAULT_CORE_LOAD_THREADS_IN_CLOUD = 8;
        public static final int DEFAULT_INDEX_SEARCHER_EXECUTOR_THREADS = 0;
        private static final String DEFAULT_CORESLOCATORCLASS = "org.apache.solr.core.CorePropertiesLocator";
        private static final String DEFAULT_CORESORTERCLASS = "org.apache.solr.core.CoreSorter";
        private static final String DEFAULT_ADMINHANDLERCLASS = "org.apache.solr.handler.admin.CoreAdminHandler";
        private static final String DEFAULT_INFOHANDLERCLASS = "org.apache.solr.handler.admin.InfoHandler";
        private static final String DEFAULT_COLLECTIONSHANDLERCLASS = "org.apache.solr.handler.admin.CollectionsHandler";
        private static final String DEFAULT_HEALTHCHECKHANDLERCLASS = "org.apache.solr.handler.admin.HealthCheckHandler";
        private static final String DEFAULT_CONFIGSETSHANDLERCLASS = "org.apache.solr.handler.admin.ConfigSetsHandler";
        public static final Set<String> DEFAULT_HIDDEN_SYS_PROPS = Set.of("javax\\.net\\.ssl\\.keyStorePassword", "javax\\.net\\.ssl\\.trustStorePassword", "basicauth", "zkDigestPassword", "zkDigestReadonlyPassword", "aws\\.secretKey", "aws\\.secretAccessKey", "http\\.proxyPassword", ".*password.*", ".*secret.*");

        public NodeConfigBuilder(String nodeName, Path solrHome) {
            this.nodeName = nodeName;
            this.solrHome = solrHome.toAbsolutePath();
            this.coreRootDirectory = solrHome;
            this.setSolrDataHome(System.getProperty("solr.data.home"));
            this.setConfigSetBaseDirectory("configsets");
            this.metricsConfig = new MetricsConfig.MetricsConfigBuilder().build();
        }

        public NodeConfigBuilder setCoreRootDirectory(String coreRootDirectory) {
            this.coreRootDirectory = this.solrHome.resolve(coreRootDirectory).normalize();
            return this;
        }

        public NodeConfigBuilder setCoresLocatorClass(String coresLocatorClass) {
            this.coresLocatorClass = coresLocatorClass;
            return this;
        }

        public NodeConfigBuilder setCoreSorterClass(String coreSorterClass) {
            this.coreSorterClass = coreSorterClass;
            return this;
        }

        public NodeConfigBuilder setSolrDataHome(String solrDataHomeString) {
            if (solrDataHomeString != null && !solrDataHomeString.isEmpty()) {
                this.solrDataHome = this.solrHome.resolve(solrDataHomeString).normalize();
            }
            return this;
        }

        public NodeConfigBuilder setBooleanQueryMaxClauseCount(Integer booleanQueryMaxClauseCount) {
            this.booleanQueryMaxClauseCount = booleanQueryMaxClauseCount;
            return this;
        }

        public NodeConfigBuilder setConfigSetBaseDirectory(String configSetBaseDirectory) {
            this.configSetBaseDirectory = this.solrHome.resolve(configSetBaseDirectory);
            return this;
        }

        public NodeConfigBuilder setSharedLibDirectory(String sharedLibDirectory) {
            this.sharedLibDirectory = sharedLibDirectory;
            return this;
        }

        public NodeConfigBuilder setShardHandlerFactoryConfig(PluginInfo shardHandlerFactoryConfig) {
            this.shardHandlerFactoryConfig = shardHandlerFactoryConfig;
            return this;
        }

        public NodeConfigBuilder setUpdateShardHandlerConfig(UpdateShardHandlerConfig updateShardHandlerConfig) {
            this.updateShardHandlerConfig = updateShardHandlerConfig;
            return this;
        }

        public NodeConfigBuilder setCoreAdminHandlerClass(String coreAdminHandlerClass) {
            this.coreAdminHandlerClass = coreAdminHandlerClass;
            return this;
        }

        public NodeConfigBuilder setCoreAdminHandlerActions(Map<String, String> coreAdminHandlerActions) {
            this.coreAdminHandlerActions = coreAdminHandlerActions;
            return this;
        }

        public NodeConfigBuilder setCollectionsAdminHandlerClass(String collectionsAdminHandlerClass) {
            this.collectionsAdminHandlerClass = collectionsAdminHandlerClass;
            return this;
        }

        public NodeConfigBuilder setHealthCheckHandlerClass(String healthCheckHandlerClass) {
            this.healthCheckHandlerClass = healthCheckHandlerClass;
            return this;
        }

        public NodeConfigBuilder setInfoHandlerClass(String infoHandlerClass) {
            this.infoHandlerClass = infoHandlerClass;
            return this;
        }

        public NodeConfigBuilder setConfigSetsHandlerClass(String configSetsHandlerClass) {
            this.configSetsHandlerClass = configSetsHandlerClass;
            return this;
        }

        public NodeConfigBuilder setLogWatcherConfig(LogWatcherConfig logWatcherConfig) {
            this.logWatcherConfig = logWatcherConfig;
            return this;
        }

        public NodeConfigBuilder setCloudConfig(CloudConfig cloudConfig) {
            this.cloudConfig = cloudConfig;
            return this;
        }

        public NodeConfigBuilder setCoreLoadThreads(int coreLoadThreads) {
            this.coreLoadThreads = coreLoadThreads;
            return this;
        }

        public NodeConfigBuilder setReplayUpdatesThreads(int replayUpdatesThreads) {
            this.replayUpdatesThreads = replayUpdatesThreads;
            return this;
        }

        public NodeConfigBuilder setIndexSearcherExecutorThreads(int indexSearcherExecutorThreads) {
            this.indexSearcherExecutorThreads = indexSearcherExecutorThreads;
            return this;
        }

        @Deprecated
        public NodeConfigBuilder setTransientCacheSize(int transientCacheSize) {
            this.transientCacheSize = transientCacheSize;
            return this;
        }

        public NodeConfigBuilder setUseSchemaCache(boolean useSchemaCache) {
            this.useSchemaCache = useSchemaCache;
            return this;
        }

        public NodeConfigBuilder setManagementPath(String managementPath) {
            this.managementPath = managementPath;
            return this;
        }

        public NodeConfigBuilder setSolrProperties(Properties solrProperties) {
            this.solrProperties = solrProperties;
            return this;
        }

        public NodeConfigBuilder setBackupRepositoryPlugins(PluginInfo[] backupRepositoryPlugins) {
            this.backupRepositoryPlugins = backupRepositoryPlugins;
            return this;
        }

        public NodeConfigBuilder setMetricsConfig(MetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        public NodeConfigBuilder setCachesConfig(Map<String, CacheConfig> cachesConfig) {
            this.cachesConfig = cachesConfig;
            return this;
        }

        public NodeConfigBuilder setTracerConfig(PluginInfo tracerConfig) {
            this.tracerConfig = tracerConfig;
            return this;
        }

        public NodeConfigBuilder setClusterPlugins(PluginInfo[] clusterPlugins) {
            this.clusterPlugins = clusterPlugins;
            return this;
        }

        public NodeConfigBuilder setFromZookeeper(boolean fromZookeeper) {
            this.fromZookeeper = fromZookeeper;
            return this;
        }

        public NodeConfigBuilder setDefaultZkHost(String defaultZkHost) {
            this.defaultZkHost = defaultZkHost;
            return this;
        }

        public NodeConfigBuilder setAllowPaths(Set<Path> paths) {
            this.allowPaths = paths;
            return this;
        }

        public NodeConfigBuilder setAllowUrls(List<String> urls) {
            this.allowUrls = urls;
            return this;
        }

        public NodeConfigBuilder setHideStackTrace(boolean hide) {
            this.hideStackTrace = hide;
            return this;
        }

        public NodeConfigBuilder setConfigSetServiceClass(String configSetServiceClass) {
            this.configSetServiceClass = configSetServiceClass;
            return this;
        }

        public NodeConfigBuilder setModules(String moduleNames) {
            this.modules = moduleNames;
            return this;
        }

        public NodeConfigBuilder setHiddenSysProps(String hiddenSysProps) {
            this.hiddenSysProps = hiddenSysProps;
            return this;
        }

        private Set<String> resolveHiddenSysPropsFromSysPropOrEnvOrDefault(String hiddenSysProps) {
            if (!StrUtils.isNotNullOrEmpty((String)hiddenSysProps)) {
                String fromProps = System.getProperty("solr.hiddenSysProps");
                if (StrUtils.isNotNullOrEmpty((String)fromProps)) {
                    fromProps = System.getProperty("solr.redaction.system.pattern");
                }
                String fromEnv = System.getenv("SOLR_HIDDEN_SYS_PROPS");
                if (StrUtils.isNotNullOrEmpty((String)fromProps)) {
                    hiddenSysProps = fromProps;
                } else if (StrUtils.isNotNullOrEmpty((String)fromEnv)) {
                    hiddenSysProps = fromEnv;
                }
            }
            Set hiddenSysPropSet = Collections.emptySet();
            if (hiddenSysProps != null) {
                hiddenSysPropSet = StrUtils.splitSmart((String)hiddenSysProps, (char)',').stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
            }
            return hiddenSysPropSet.isEmpty() ? DEFAULT_HIDDEN_SYS_PROPS : hiddenSysPropSet;
        }

        public NodeConfig build() {
            if (this.loader == null) {
                this.loader = new SolrResourceLoader(this.solrHome);
            }
            return new NodeConfig(this.nodeName, this.coreRootDirectory, this.coresLocatorClass, this.coreSorterClass, this.solrDataHome, this.booleanQueryMaxClauseCount, this.configSetBaseDirectory, this.sharedLibDirectory, this.shardHandlerFactoryConfig, this.updateShardHandlerConfig, this.coreAdminHandlerClass, this.coreAdminHandlerActions, this.collectionsAdminHandlerClass, this.healthCheckHandlerClass, this.infoHandlerClass, this.configSetsHandlerClass, this.logWatcherConfig, this.cloudConfig, this.coreLoadThreads, this.replayUpdatesThreads, this.indexSearcherExecutorThreads, this.transientCacheSize, this.useSchemaCache, this.managementPath, this.solrHome, this.loader, this.solrProperties, this.backupRepositoryPlugins, this.metricsConfig, this.cachesConfig, this.tracerConfig, this.clusterPlugins, this.fromZookeeper, this.defaultZkHost, this.allowPaths, this.allowUrls, this.hideStackTrace, this.configSetServiceClass, this.modules, this.resolveHiddenSysPropsFromSysPropOrEnvOrDefault(this.hiddenSysProps));
        }

        public NodeConfigBuilder setSolrResourceLoader(SolrResourceLoader resourceLoader) {
            this.loader = resourceLoader;
            return this;
        }
    }
}

