/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDate;
import org.apache.lucene.util.mutable.MutableValueDouble;
import org.apache.lucene.util.mutable.MutableValueFloat;
import org.apache.lucene.util.mutable.MutableValueInt;
import org.apache.lucene.util.mutable.MutableValueLong;
import org.apache.solr.schema.SchemaField;

public class PointMerger {
    public static int TOTAL_BUFFER_SIZE = 1000000;
    public static int MIN_SEG_BUFFER_SIZE = 100;

    static BreakException breakException() {
        return new BreakException();
    }

    static class BreakException
    extends RuntimeException {
        BreakException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static class DateSeg
    extends LongSeg {
        DateSeg(PointValues points, int capacity) {
            super(points, capacity);
            this.mval = new MutableValueDate();
            this.currentValue = this.mval;
        }
    }

    static class DoubleSeg
    extends BaseSeg {
        final double[] values;
        double last = -1.7976931348623157E308;
        final MutableValueDouble mval;

        DoubleSeg(PointValues points, int capacity) {
            super(points, capacity);
            this.values = new double[capacity];
            this.mval = new MutableValueDouble();
            this.currentValue = this.mval;
        }

        @Override
        public int setNextValue() throws IOException {
            if (this.readPos >= this.pos) {
                if (this.last != Double.MAX_VALUE) {
                    this.last = Math.nextUp(this.last);
                    this.refill();
                }
                if (this.readPos >= this.pos) {
                    this.last = Double.MAX_VALUE;
                    this.currentCount = -1;
                    return -1;
                }
            }
            ++this.readPos;
            this.mval.value = this.values[this.readPos];
            this.currentCount = this.count[this.readPos];
            return this.currentCount;
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            double v = DoublePoint.decodeDimension((byte[])packedValue, (int)0);
            if (v < this.last) {
                return;
            }
            if (v == this.last && this.pos >= 0) {
                int n = this.pos;
                this.count[n] = this.count[n] + 1;
            } else if (this.pos + 1 < this.values.length) {
                this.last = v;
                ++this.pos;
                this.values[this.pos] = v;
                this.count[this.pos] = 1;
            } else {
                throw PointMerger.breakException();
            }
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            double v = DoublePoint.decodeDimension((byte[])maxPackedValue, (int)0);
            if (v >= this.last) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static class FloatSeg
    extends BaseSeg {
        final float[] values;
        float last = -3.4028235E38f;
        final MutableValueFloat mval;

        FloatSeg(PointValues points, int capacity) {
            super(points, capacity);
            this.values = new float[capacity];
            this.mval = new MutableValueFloat();
            this.currentValue = this.mval;
        }

        @Override
        public int setNextValue() throws IOException {
            if (this.readPos >= this.pos) {
                if (this.last != Float.MAX_VALUE) {
                    this.last = Math.nextUp(this.last);
                    this.refill();
                }
                if (this.readPos >= this.pos) {
                    this.last = Float.MAX_VALUE;
                    this.currentCount = -1;
                    return -1;
                }
            }
            ++this.readPos;
            this.mval.value = this.values[this.readPos];
            this.currentCount = this.count[this.readPos];
            return this.currentCount;
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            float v = FloatPoint.decodeDimension((byte[])packedValue, (int)0);
            if (v < this.last) {
                return;
            }
            if (v == this.last && this.pos >= 0) {
                int n = this.pos;
                this.count[n] = this.count[n] + 1;
            } else if (this.pos + 1 < this.values.length) {
                this.last = v;
                ++this.pos;
                this.values[this.pos] = v;
                this.count[this.pos] = 1;
            } else {
                throw PointMerger.breakException();
            }
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            float v = FloatPoint.decodeDimension((byte[])maxPackedValue, (int)0);
            if (v >= this.last) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static class LongSeg
    extends BaseSeg {
        final long[] values;
        long last = Long.MIN_VALUE;
        MutableValueLong mval;

        LongSeg(PointValues points, int capacity) {
            super(points, capacity);
            this.values = new long[capacity];
            this.mval = new MutableValueLong();
            this.currentValue = this.mval;
        }

        @Override
        public int setNextValue() throws IOException {
            if (this.readPos >= this.pos) {
                if (this.last != Long.MAX_VALUE) {
                    ++this.last;
                    this.refill();
                }
                if (this.readPos >= this.pos) {
                    this.last = Long.MAX_VALUE;
                    this.currentCount = -1;
                    return -1;
                }
            }
            ++this.readPos;
            this.mval.value = this.values[this.readPos];
            this.currentCount = this.count[this.readPos];
            return this.currentCount;
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            long v = LongPoint.decodeDimension((byte[])packedValue, (int)0);
            if (v < this.last) {
                return;
            }
            if (v == this.last && this.pos >= 0) {
                int n = this.pos;
                this.count[n] = this.count[n] + 1;
            } else if (this.pos + 1 < this.values.length) {
                this.last = v;
                ++this.pos;
                this.values[this.pos] = v;
                this.count[this.pos] = 1;
            } else {
                throw PointMerger.breakException();
            }
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            long v = LongPoint.decodeDimension((byte[])maxPackedValue, (int)0);
            if (v >= this.last) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static class IntSeg
    extends BaseSeg {
        final int[] values;
        int last = Integer.MIN_VALUE;
        final MutableValueInt mval;

        IntSeg(PointValues points, int capacity) {
            super(points, capacity);
            this.values = new int[capacity];
            this.mval = new MutableValueInt();
            this.currentValue = this.mval;
        }

        @Override
        public int setNextValue() throws IOException {
            if (this.readPos >= this.pos) {
                if (this.last != Integer.MAX_VALUE) {
                    ++this.last;
                    this.refill();
                }
                if (this.readPos >= this.pos) {
                    this.last = Integer.MAX_VALUE;
                    this.currentCount = -1;
                    return -1;
                }
            }
            ++this.readPos;
            this.mval.value = this.values[this.readPos];
            this.currentCount = this.count[this.readPos];
            return this.currentCount;
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            int v = IntPoint.decodeDimension((byte[])packedValue, (int)0);
            if (v < this.last) {
                return;
            }
            if (v == this.last && this.pos >= 0) {
                int n = this.pos;
                this.count[n] = this.count[n] + 1;
            } else if (this.pos + 1 < this.values.length) {
                this.last = v;
                ++this.pos;
                this.values[this.pos] = v;
                this.count[this.pos] = 1;
            } else {
                throw PointMerger.breakException();
            }
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            int v = IntPoint.decodeDimension((byte[])maxPackedValue, (int)0);
            if (v >= this.last) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    static abstract class BaseSeg
    implements PointValues.IntersectVisitor {
        final PointValues points;
        final int[] count;
        int pos = -1;
        int readPos = -1;
        MutableValue currentValue;
        int currentCount;

        BaseSeg(PointValues points, int capacity) {
            this.points = points;
            this.count = new int[capacity];
        }

        public static boolean lessThan(BaseSeg a, BaseSeg b) {
            return a.currentValue.compareTo(b.currentValue) < 0;
        }

        public MutableValue getMutableValue() {
            return this.currentValue;
        }

        public int getCurrentCount() {
            return this.currentCount;
        }

        public int setNextValue() throws IOException {
            return 0;
        }

        void refill() throws IOException {
            assert (this.readPos >= this.pos);
            this.readPos = -1;
            this.pos = -1;
            try {
                this.points.intersect((PointValues.IntersectVisitor)this);
            }
            catch (BreakException breakException) {
                // empty catch block
            }
        }

        public void visit(int docID) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class PQueue
    extends PriorityQueue<BaseSeg> {
        public PQueue(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(BaseSeg a, BaseSeg b) {
            return BaseSeg.lessThan(a, b);
        }
    }

    public static class ValueIterator {
        PQueue queue;
        MutableValue topVal;

        public ValueIterator(SchemaField field, List<LeafReaderContext> readers) throws IOException {
            this(field, readers, TOTAL_BUFFER_SIZE, MIN_SEG_BUFFER_SIZE);
        }

        public ValueIterator(SchemaField field, List<LeafReaderContext> readers, int totalBufferSize, int minSegBufferSize) throws IOException {
            assert (field.getType().isPointField());
            this.queue = new PQueue(readers.size());
            if (readers.isEmpty()) {
                return;
            }
            LeafReaderContext leafReaderContext = readers.get(readers.size() - 1);
            long ndocs = (long)leafReaderContext.docBase + (long)leafReaderContext.reader().maxDoc();
            for (LeafReaderContext ctx : readers) {
                int count;
                PointValues pv = ctx.reader().getPointValues(field.getName());
                if (pv == null) continue;
                BaseSeg seg = null;
                int capacity = (int)((long)totalBufferSize * (long)ctx.reader().maxDoc() / ndocs);
                capacity = Math.max(capacity, minSegBufferSize);
                switch (field.getType().getNumberType()) {
                    case INTEGER: {
                        seg = new IntSeg(pv, capacity);
                        break;
                    }
                    case LONG: {
                        seg = new LongSeg(pv, capacity);
                        break;
                    }
                    case FLOAT: {
                        seg = new FloatSeg(pv, capacity);
                        break;
                    }
                    case DOUBLE: {
                        seg = new DoubleSeg(pv, capacity);
                        break;
                    }
                    case DATE: {
                        seg = new DateSeg(pv, capacity);
                    }
                }
                if ((count = seg.setNextValue()) < 0) continue;
                this.queue.add(seg);
            }
            if (this.queue.size() > 0) {
                this.topVal = ((BaseSeg)this.queue.top()).getMutableValue().duplicate();
            }
        }

        public MutableValue getMutableValue() {
            return this.topVal;
        }

        public long getNextCount() throws IOException {
            if (this.queue.size() == 0) {
                return -1L;
            }
            BaseSeg seg = (BaseSeg)this.queue.top();
            this.topVal.copy(seg.getMutableValue());
            long count = 0L;
            do {
                count += (long)seg.getCurrentCount();
                int nextCount = seg.setNextValue();
                if (nextCount < 0) {
                    this.queue.pop();
                    if (this.queue.size() != 0) continue;
                    break;
                }
                this.queue.updateTop();
            } while ((seg = (BaseSeg)this.queue.top()).getMutableValue().equalsSameType((Object)this.topVal));
            return count;
        }
    }
}

