/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.apache.http.NoHttpResponseException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.StreamingSolrClients;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCmdDistributor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StreamingSolrClients clients;
    private boolean finished = false;
    private int retryPause = 500;
    private final List<SolrError> allErrors = new ArrayList<SolrError>();
    private final List<SolrError> errors = Collections.synchronizedList(new ArrayList());
    private final CompletionService<Object> completionService;
    private final Set<Future<Object>> pending = new HashSet<Future<Object>>();
    public static Diagnostics.Callable testing_errorHook;

    public SolrCmdDistributor(UpdateShardHandler updateShardHandler) {
        this.clients = new StreamingSolrClients(updateShardHandler);
        this.completionService = new ExecutorCompletionService<Object>(updateShardHandler.getUpdateExecutor());
    }

    SolrCmdDistributor(StreamingSolrClients clients, int retryPause) {
        this.clients = clients;
        this.retryPause = retryPause;
        this.completionService = new ExecutorCompletionService<Object>(clients.getUpdateExecutor());
    }

    public void finish() {
        try {
            assert (!this.finished) : "lifecycle sanity check";
            this.finished = true;
            this.blockAndDoRetries();
        }
        catch (IOException e) {
            log.warn("Unable to finish sending updates", (Throwable)e);
        }
        finally {
            this.clients.shutdown();
        }
    }

    @Override
    public void close() {
        this.clients.shutdown();
    }

    private void doRetriesIfNeeded() throws IOException {
        ArrayList<SolrError> errors = new ArrayList<SolrError>(this.errors);
        errors.addAll(this.clients.getErrors());
        ArrayList<SolrError> resubmitList = new ArrayList<SolrError>();
        if (log.isInfoEnabled() && errors.size() > 0) {
            log.info("SolrCmdDistributor found {} errors", (Object)errors.size());
        }
        if (log.isDebugEnabled() && errors.size() > 0) {
            StringBuilder builder = new StringBuilder("SolrCmdDistributor found:");
            int maxErrorsToShow = 10;
            for (SolrError e : errors) {
                if (maxErrorsToShow-- <= 0) break;
                builder.append("\n").append(e);
            }
            if (errors.size() > 10) {
                builder.append("\n... and ");
                builder.append(errors.size() - 10);
                builder.append(" more");
            }
            log.debug("{}", (Object)builder);
        }
        for (SolrError err : errors) {
            try {
                boolean isRetry = err.req.shouldRetry(err);
                if (testing_errorHook != null) {
                    Diagnostics.call(testing_errorHook, err.e);
                }
                if (isRetry) {
                    ++err.req.retries;
                    resubmitList.add(err);
                    continue;
                }
                this.allErrors.add(err);
            }
            catch (Exception e) {
                log.error("Unexpected Error while doing request retries", (Throwable)e);
            }
        }
        if (resubmitList.size() > 0) {
            try {
                int backoffTime = Math.min(this.retryPause * ((SolrError)resubmitList.get((int)0)).req.retries, 2000);
                if (log.isDebugEnabled()) {
                    log.debug("Sleeping {}ms before re-submitting {} requests", (Object)backoffTime, (Object)resubmitList.size());
                }
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn(null, (Throwable)e);
            }
        }
        this.clients.clearErrors();
        this.errors.clear();
        for (SolrError err : resubmitList) {
            if (err.req.node instanceof ForwardNode) {
                log.error("forwarding update to {} failed - retrying ... retries: {}/{}. {} params: {} rsp: {}", new Object[]{err.req.node.getUrl(), err.req.retries, err.req.node.getMaxRetries(), err.req.cmd, err.req.uReq.getParams(), err.statusCode, err.e});
            } else {
                log.error("FROMLEADER request to {} failed - retrying ... retries: {}/{}. {} params: {} rsp: {}", new Object[]{err.req.node.getUrl(), err.req.retries, err.req.node.getMaxRetries(), err.req.cmd, err.req.uReq.getParams(), err.statusCode, err.e});
            }
            this.submit(err.req, false);
        }
        if (resubmitList.size() > 0) {
            this.blockAndDoRetries();
        }
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.distribDelete(cmd, nodes, params, false, null, null);
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean sync, DistributedUpdateProcessor.RollupRequestReplicationTracker rollupTracker, DistributedUpdateProcessor.LeaderRequestReplicationTracker leaderTracker) throws IOException {
        if (!cmd.isDeleteById()) {
            this.blockAndDoRetries();
        }
        for (Node node : nodes) {
            UpdateRequest uReq = new UpdateRequest();
            uReq.setParams(params);
            uReq.setCommitWithin(cmd.commitWithin);
            if (cmd.isDeleteById()) {
                uReq.deleteById(cmd.getId(), cmd.getRoute(), Long.valueOf(cmd.getVersion()));
            } else {
                uReq.deleteByQuery(cmd.query);
            }
            this.submit(new Req(cmd, node, uReq, sync, rollupTracker, leaderTracker), false);
        }
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.distribAdd(cmd, nodes, params, false, null, null);
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean synchronous) throws IOException {
        this.distribAdd(cmd, nodes, params, synchronous, null, null);
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean synchronous, DistributedUpdateProcessor.RollupRequestReplicationTracker rollupTracker, DistributedUpdateProcessor.LeaderRequestReplicationTracker leaderTracker) throws IOException {
        for (Node node : nodes) {
            UpdateRequest uReq = new UpdateRequest();
            if (cmd.isLastDocInBatch) {
                uReq.lastDocInBatch();
            }
            uReq.setParams(params);
            uReq.add(cmd.solrDoc, Integer.valueOf(cmd.commitWithin), Boolean.valueOf(cmd.overwrite));
            if (cmd.isInPlaceUpdate()) {
                params.set("distrib.inplace.prevversion", new String[]{String.valueOf(cmd.prevVersion)});
            }
            this.submit(new Req(cmd, node, uReq, synchronous, rollupTracker, leaderTracker), false);
        }
    }

    public void distribCommit(CommitUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.blockAndDoRetries();
        log.debug("Distrib commit to: {} params: {}", nodes, (Object)params);
        for (Node node : nodes) {
            UpdateRequest uReq = new UpdateRequest();
            uReq.setParams(params);
            this.addCommit(uReq, cmd);
            this.submit(new Req(cmd, node, uReq, false), true);
        }
    }

    public void blockAndDoRetries() throws IOException {
        this.clients.blockUntilFinished();
        while (this.pending != null && this.pending.size() > 0) {
            Future<Object> future = null;
            try {
                future = this.completionService.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("blockAndDoRetries interrupted", (Throwable)e);
            }
            if (future == null) break;
            this.pending.remove(future);
        }
        this.doRetriesIfNeeded();
    }

    void addCommit(UpdateRequest ureq, CommitUpdateCommand cmd) {
        if (cmd == null) {
            return;
        }
        ureq.setAction(cmd.optimize ? AbstractUpdateRequest.ACTION.OPTIMIZE : AbstractUpdateRequest.ACTION.COMMIT, false, cmd.waitSearcher, cmd.maxOptimizeSegments, cmd.softCommit, cmd.expungeDeletes, cmd.openSearcher);
    }

    private void submit(Req req, boolean isCommit) throws IOException {
        if (SolrRequestInfo.getRequestInfo() != null) {
            req.uReq.setUserPrincipal(SolrRequestInfo.getRequestInfo().getReq().getUserPrincipal());
        }
        if (req.synchronous) {
            this.blockAndDoRetries();
            try {
                this.clients.getHttpClient().requestWithBaseUrl(req.node.getBaseUrl(), req.node.getCoreName(), (SolrRequest)req.uReq);
            }
            catch (Exception e) {
                log.error("Exception making request", (Throwable)e);
                SolrError error = new SolrError();
                error.e = e;
                error.req = req;
                if (e instanceof SolrException) {
                    error.statusCode = ((SolrException)((Object)e)).code();
                }
                this.errors.add(error);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("sending update to {} retry: {} {} params {}", new Object[]{req.node.getUrl(), req.retries, req.cmd, req.uReq.getParams()});
        }
        if (isCommit) {
            this.pending.add(this.completionService.submit(() -> {
                this.doRequest(req);
                return null;
            }));
        } else {
            this.doRequest(req);
        }
    }

    private void doRequest(Req req) {
        try {
            SolrClient solrClient = this.clients.getSolrClient(req);
            solrClient.request((SolrRequest)req.uReq);
        }
        catch (Exception e) {
            log.error("Exception making request", (Throwable)e);
            SolrError error = new SolrError();
            error.e = e;
            error.req = req;
            if (e instanceof SolrException) {
                error.statusCode = ((SolrException)((Object)e)).code();
            }
            this.errors.add(error);
        }
    }

    public List<SolrError> getErrors() {
        return this.allErrors;
    }

    public static class ForwardNode
    extends StdNode {
        private ZkStateReader zkStateReader;

        public ForwardNode(ZkCoreNodeProps nodeProps, ZkStateReader zkStateReader, String collection, String shardId, int maxRetries) {
            super(nodeProps, collection, shardId, maxRetries);
            this.zkStateReader = zkStateReader;
            this.collection = collection;
            this.shardId = shardId;
        }

        @Override
        public boolean checkRetry(SolrError err) {
            boolean doRetry = false;
            if (err.statusCode == 404 || err.statusCode == 403 || err.statusCode == 503) {
                doRetry = true;
            }
            if (err.e instanceof SolrServerException && ((SolrServerException)((Object)err.e)).getRootCause() instanceof ConnectException) {
                doRetry = true;
            } else if (err.e instanceof ConnectException) {
                doRetry = true;
            }
            if (doRetry) {
                ZkCoreNodeProps leaderProps;
                try {
                    leaderProps = new ZkCoreNodeProps((ZkNodeProps)this.zkStateReader.getLeaderRetry(this.collection, this.shardId));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                catch (Exception e) {
                    log.warn(null, (Throwable)e);
                    return true;
                }
                this.nodeProps = leaderProps;
            }
            return doRetry;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.shardId == null ? 0 : this.shardId.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof ForwardNode)) {
                return false;
            }
            ForwardNode other = (ForwardNode)obj;
            return Objects.equals(this.nodeProps.getCoreUrl(), other.nodeProps.getCoreUrl());
        }
    }

    public static class StdNode
    extends Node {
        protected ZkCoreNodeProps nodeProps;
        protected String collection;
        protected String shardId;
        private final boolean retry;
        private final int maxRetries;

        public StdNode(ZkCoreNodeProps nodeProps) {
            this(nodeProps, null, null, 0);
        }

        public StdNode(ZkCoreNodeProps nodeProps, String collection, String shardId) {
            this(nodeProps, collection, shardId, 0);
        }

        public StdNode(ZkCoreNodeProps nodeProps, String collection, String shardId, int maxRetries) {
            this.nodeProps = nodeProps;
            this.collection = collection;
            this.shardId = shardId;
            this.retry = maxRetries > 0;
            this.maxRetries = maxRetries;
        }

        @Override
        public String getCollection() {
            return this.collection;
        }

        @Override
        public String getShardId() {
            return this.shardId;
        }

        @Override
        public String getUrl() {
            return this.nodeProps.getCoreUrl();
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.nodeProps.getCoreUrl();
        }

        @Override
        public boolean checkRetry(SolrError err) {
            if (!this.retry) {
                return false;
            }
            if (err.statusCode == 404 || err.statusCode == 403 || err.statusCode == 503) {
                return true;
            }
            return err.e instanceof SolrServerException ? this.isRetriableException(((SolrServerException)((Object)err.e)).getRootCause()) : this.isRetriableException(err.e);
        }

        private boolean isRetriableException(Throwable t) {
            return t instanceof SocketException || t instanceof NoHttpResponseException || t instanceof SocketTimeoutException;
        }

        @Override
        public String getBaseUrl() {
            return this.nodeProps.getBaseUrl();
        }

        @Override
        public String getCoreName() {
            return this.nodeProps.getCoreName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            String baseUrl = this.nodeProps.getBaseUrl();
            String coreName = this.nodeProps.getCoreName();
            String url = this.nodeProps.getCoreUrl();
            result = 31 * result + (baseUrl == null ? 0 : baseUrl.hashCode());
            result = 31 * result + (coreName == null ? 0 : coreName.hashCode());
            result = 31 * result + (url == null ? 0 : url.hashCode());
            result = 31 * result + Boolean.hashCode(this.retry);
            result = 31 * result + Integer.hashCode(this.maxRetries);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StdNode)) {
                return false;
            }
            StdNode other = (StdNode)obj;
            return this.retry == other.retry && this.maxRetries == other.maxRetries && Objects.equals(this.nodeProps.getBaseUrl(), other.nodeProps.getBaseUrl()) && Objects.equals(this.nodeProps.getCoreName(), other.nodeProps.getCoreName()) && Objects.equals(this.nodeProps.getCoreUrl(), other.nodeProps.getCoreUrl());
        }

        @Override
        public ZkCoreNodeProps getNodeProps() {
            return this.nodeProps;
        }

        @Override
        public int getMaxRetries() {
            return this.maxRetries;
        }
    }

    public static abstract class Node {
        public abstract String getUrl();

        public abstract boolean checkRetry(SolrError var1);

        public abstract String getCoreName();

        public abstract String getBaseUrl();

        public abstract ZkCoreNodeProps getNodeProps();

        public abstract String getCollection();

        public abstract String getShardId();

        public abstract int getMaxRetries();
    }

    public static class SolrError {
        public Exception e;
        public int statusCode = -1;
        public Req req;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SolrCmdDistributor$Error: statusCode=").append(this.statusCode);
            sb.append("; exception=").append(String.valueOf(this.e));
            sb.append("; req=").append(String.valueOf(this.req));
            return sb.toString();
        }
    }

    public static class Response {
        public List<SolrError> errors = new ArrayList<SolrError>();
    }

    public static class Req {
        public Node node;
        public UpdateRequest uReq;
        public int retries;
        public boolean synchronous;
        public UpdateCommand cmd;
        private final DistributedUpdateProcessor.RollupRequestReplicationTracker rollupTracker;
        private final DistributedUpdateProcessor.LeaderRequestReplicationTracker leaderTracker;

        public Req(UpdateCommand cmd, Node node, UpdateRequest uReq, boolean synchronous) {
            this(cmd, node, uReq, synchronous, null, null);
        }

        public Req(UpdateCommand cmd, Node node, UpdateRequest uReq, boolean synchronous, DistributedUpdateProcessor.RollupRequestReplicationTracker rollupTracker, DistributedUpdateProcessor.LeaderRequestReplicationTracker leaderTracker) {
            this.node = node;
            this.uReq = uReq;
            this.synchronous = synchronous;
            this.cmd = cmd;
            this.rollupTracker = rollupTracker;
            this.leaderTracker = leaderTracker;
        }

        public boolean shouldRetry(SolrError err) {
            boolean isRetry = this.node.checkRetry(err);
            return (isRetry &= this.uReq.getDeleteQuery() == null || this.uReq.getDeleteQuery().isEmpty()) && this.retries < this.node.getMaxRetries();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SolrCmdDistributor$Req: cmd=").append(this.cmd.toString());
            sb.append("; node=").append(String.valueOf(this.node));
            return sb.toString();
        }

        public void trackRequestResult(org.eclipse.jetty.client.api.Response resp, InputStream respBody, boolean success) {
            int rfFromResp = this.getRfFromResponse(respBody);
            if (this.leaderTracker != null && rfFromResp == Integer.MAX_VALUE) {
                this.leaderTracker.trackRequestResult(this.node, success);
            }
            if (this.rollupTracker != null) {
                this.rollupTracker.testAndSetAchievedRf(rfFromResp);
            }
        }

        private int getRfFromResponse(InputStream inputStream) {
            if (inputStream != null) {
                try {
                    NamedList hdrList;
                    Object rfObj;
                    BinaryResponseParser brp = new BinaryResponseParser();
                    NamedList nl = brp.processResponse(inputStream, null);
                    Object hdr = nl.get("responseHeader");
                    if (hdr != null && hdr instanceof NamedList && (rfObj = (hdrList = (NamedList)hdr).get("rf")) != null && rfObj instanceof Integer) {
                        return (Integer)rfObj;
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to parse response from {} during replication factor accounting", (Object)this.node, (Object)e);
                }
            }
            return Integer.MAX_VALUE;
        }
    }
}

