/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateHandler
implements SolrInfoBean {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrCore core;
    protected final SchemaField idField;
    protected final FieldType idFieldType;
    protected List<SolrEventListener> commitCallbacks = Collections.synchronizedList(new ArrayList());
    protected List<SolrEventListener> softCommitCallbacks = Collections.synchronizedList(new ArrayList());
    protected List<SolrEventListener> optimizeCallbacks = Collections.synchronizedList(new ArrayList());
    protected final UpdateLog ulog;
    protected SolrMetricsContext solrMetricsContext;

    private void parseEventListeners() {
        for (PluginInfo info : this.core.getSolrConfig().getPluginInfos(SolrEventListener.class.getName())) {
            SolrEventListener obj;
            String event = info.attributes.get("event");
            if ("postCommit".equals(event)) {
                obj = this.core.createEventListener(info);
                this.commitCallbacks.add(obj);
                log.info("added SolrEventListener for postCommit: {}", (Object)obj);
                continue;
            }
            if (!"postOptimize".equals(event)) continue;
            obj = this.core.createEventListener(info);
            this.optimizeCallbacks.add(obj);
            log.info("added SolrEventListener for postOptimize: {}", (Object)obj);
        }
    }

    public void informEventListeners(SolrCore core) {
        for (SolrEventListener listener : this.commitCallbacks) {
            if (!(listener instanceof SolrCoreAware)) continue;
            ((SolrCoreAware)((Object)listener)).inform(core);
        }
        for (SolrEventListener listener : this.optimizeCallbacks) {
            if (!(listener instanceof SolrCoreAware)) continue;
            ((SolrCoreAware)((Object)listener)).inform(core);
        }
    }

    protected void callPostCommitCallbacks() {
        for (SolrEventListener listener : this.commitCallbacks) {
            listener.postCommit();
        }
    }

    protected void callPostSoftCommitCallbacks() {
        for (SolrEventListener listener : this.softCommitCallbacks) {
            listener.postSoftCommit();
        }
    }

    protected void callPostOptimizeCallbacks() {
        for (SolrEventListener listener : this.optimizeCallbacks) {
            listener.postCommit();
        }
    }

    public UpdateHandler(SolrCore core) {
        this(core, null, true);
    }

    public UpdateHandler(SolrCore core, UpdateLog updateLog) {
        this(core, updateLog, true);
    }

    public UpdateHandler(SolrCore core, UpdateLog updateLog, boolean initUlog) {
        boolean skipUpdateLog;
        this.core = core;
        this.idField = core.getLatestSchema().getUniqueKeyField();
        this.idFieldType = this.idField != null ? this.idField.getType() : null;
        this.parseEventListeners();
        PluginInfo ulogPluginInfo = core.getSolrConfig().getPluginInfo(UpdateLog.class.getName());
        boolean bl = skipUpdateLog = core.getCoreDescriptor().getCloudDescriptor() != null && !core.getCoreDescriptor().getCloudDescriptor().requiresTransactionLog();
        if (updateLog == null && ulogPluginInfo != null && ulogPluginInfo.isEnabled() && !skipUpdateLog) {
            DirectoryFactory dirFactory = core.getDirectoryFactory();
            UpdateLog updateLog2 = this.ulog = ulogPluginInfo.className == null ? dirFactory.newDefaultUpdateLog() : core.getResourceLoader().newInstance(ulogPluginInfo, UpdateLog.class, true);
            if (log.isInfoEnabled()) {
                log.info("Using UpdateLog implementation: {}", (Object)this.ulog.getClass().getName());
            }
            this.ulog.init(ulogPluginInfo);
            if (initUlog) {
                this.initUlog(true);
            }
        } else {
            this.ulog = updateLog;
            if (updateLog != null && initUlog) {
                this.initUlog(false);
            }
        }
    }

    protected final void initUlog(boolean closeOnError) {
        try {
            this.ulog.init(this, this.core);
        }
        catch (Throwable t) {
            if (closeOnError) {
                this.ulog.close(false, false);
            }
            throw t;
        }
    }

    public abstract void newIndexWriter(boolean var1) throws IOException;

    public abstract SolrCoreState getSolrCoreState();

    public abstract int addDoc(AddUpdateCommand var1) throws IOException;

    public abstract void delete(DeleteUpdateCommand var1) throws IOException;

    public abstract void deleteByQuery(DeleteUpdateCommand var1) throws IOException;

    public abstract int mergeIndexes(MergeIndexesCommand var1) throws IOException;

    public abstract void commit(CommitUpdateCommand var1) throws IOException;

    public abstract void rollback(RollbackUpdateCommand var1) throws IOException;

    public abstract UpdateLog getUpdateLog();

    public void registerCommitCallback(SolrEventListener listener) {
        this.commitCallbacks.add(listener);
    }

    public void registerSoftCommitCallback(SolrEventListener listener) {
        this.softCommitCallbacks.add(listener);
    }

    public void registerOptimizeCallback(SolrEventListener listener) {
        this.optimizeCallbacks.add(listener);
    }

    public abstract void split(SplitIndexCommand var1) throws IOException;

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.UPDATE;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }
}

