/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddressUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static String getHostToAdvertise() {
        String hostaddress;
        try {
            hostaddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostaddress = InetAddress.getLoopbackAddress().getHostAddress();
        }
        if ("127.0.0.1".equals(hostaddress)) {
            try {
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements()) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        InetAddress ip = ips.nextElement();
                        if (!ip.isSiteLocalAddress()) continue;
                        hostaddress = ip.getHostAddress();
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while looking for a better host name than 127.0.0.1", (Throwable)e);
            }
        }
        return hostaddress;
    }
}

