/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.PropertiesUtil;

public class DataConfigNode
implements ConfigNode {
    private final String name;
    private final Map<String, String> rawAttributes;
    private final Map<String, List<ConfigNode>> kids;
    private final String rawTextData;

    public DataConfigNode(ConfigNode root) {
        LinkedHashMap kids = new LinkedHashMap();
        this.name = root.name();
        this.rawAttributes = root.attributes();
        this.rawTextData = root.txt();
        root.forEachChild(it -> {
            List nodes = kids.computeIfAbsent(it.name(), k -> new ArrayList());
            nodes.add(new DataConfigNode((ConfigNode)it));
            return Boolean.TRUE;
        });
        for (Map.Entry entry : kids.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.setValue(List.copyOf((Collection)entry.getValue()));
        }
        this.kids = Map.copyOf(kids);
    }

    private static String substituteVal(String s) {
        return PropertiesUtil.substitute((String)s, (Function)((Function)SUBSTITUTES.get()));
    }

    public String name() {
        return this.name;
    }

    public String txt() {
        return DataConfigNode.substituteVal(this.rawTextData);
    }

    public Map<String, String> attributes() {
        if (this.rawAttributes.isEmpty()) {
            return this.rawAttributes;
        }
        return this.rawAttributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> DataConfigNode.substituteVal((String)e.getValue()), (v, vv) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
    }

    public ConfigNode child(String name) {
        List<ConfigNode> val = this.kids.get(name);
        return val == null || val.isEmpty() ? null : val.get(0);
    }

    public List<ConfigNode> getAll(String name) {
        return this.kids.getOrDefault(name, List.of());
    }

    public List<ConfigNode> getAll(Set<String> names, Predicate<ConfigNode> test) {
        if (names == null) {
            return super.getAll(names, test);
        }
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        for (String s : names) {
            List<ConfigNode> vals = this.kids.get(s);
            if (vals == null) continue;
            vals.forEach(it -> {
                if (test == null || test.test((ConfigNode)it)) {
                    result.add((ConfigNode)it);
                }
            });
        }
        return result;
    }

    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        this.kids.forEach((s, configNodes) -> {
            if (configNodes != null) {
                configNodes.forEach(fun::apply);
            }
        });
    }
}

