/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import org.apache.sis.filter.Expression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.GeometryConstructor;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

abstract class GeometryParser<R, G>
extends GeometryConstructor<R, G> {
    private static final long serialVersionUID = -4636578226555118315L;

    GeometryParser(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
        super(sQLMM, expressionArray, geometries);
    }

    @Override
    public abstract Expression<R, Object> recreate(Expression<? super R, ?>[] var1);

    @Override
    public final String getSyntax() {
        return this.getFunctionName().tip() + " ( <" + this.inputName() + "> [, <srid>] )";
    }

    abstract String inputName();

    @Override
    public final Object apply(R r) {
        Object v = this.geometry.apply(r);
        try {
            CoordinateReferenceSystem coordinateReferenceSystem;
            GeometryWrapper<G> geometryWrapper = this.parse(v);
            if (geometryWrapper == null) {
                return null;
            }
            GeometryWrapper<G> geometryWrapper2 = geometryWrapper.toGeometryType(this.operation.getGeometryType().get());
            if (geometryWrapper2 != geometryWrapper) {
                switch (this.operation) {
                    case ST_BdPolyFromWKB: 
                    case ST_BdPolyFromText: 
                    case ST_BdMPolyFromWKB: 
                    case ST_BdMPolyFromText: {
                        break;
                    }
                    default: {
                        this.warning(new IllegalArgumentException(Errors.format((short)43, this.inputName(), this.getValueClass(), geometryWrapper2.implementation().getClass())), true);
                    }
                }
            }
            if (this.srid != null && (coordinateReferenceSystem = this.getTargetCRS(r)) != null) {
                geometryWrapper2.setCoordinateReferenceSystem(coordinateReferenceSystem);
            }
            return geometryWrapper2.implementation();
        }
        catch (Exception exception) {
            this.warning(exception, false);
            return null;
        }
    }

    protected abstract GeometryWrapper<G> parse(Object var1) throws Exception;
}

