/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.DateTimeType;
import com.healthmarketscience.jackcess.crypt.CryptCodecProvider;
import com.healthmarketscience.jackcess.impl.CodecProvider;
import com.healthmarketscience.jackcess.util.LinkResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.JackcessExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JackcessParser
extends AbstractParser {
    public static final String SUMMARY_PROPERTY_PREFIX = "MDB_SUMMARY_PROP:";
    public static String MDB_PROPERTY_PREFIX = "MDB_PROP:";
    public static String USER_DEFINED_PROPERTY_PREFIX = "MDB_USER_PROP:";
    public static Property MDB_PW = Property.externalText((String)"Password");
    private static final LinkResolver IGNORE_LINK_RESOLVER = new IgnoreLinkResolver();
    private static final long serialVersionUID = -752276948656079347L;
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"x-msaccess");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    private Locale locale = Locale.ROOT;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.get((InputStream)stream);
        Database db = null;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        String password = null;
        PasswordProvider passwordProvider = (PasswordProvider)context.get(PasswordProvider.class);
        if (passwordProvider != null) {
            password = passwordProvider.getPassword(metadata);
        }
        try {
            db = password == null ? new DatabaseBuilder(tis.getFile()).setCodecProvider((CodecProvider)new CryptCodecProvider()).setReadOnly(true).open() : new DatabaseBuilder(tis.getFile()).setCodecProvider((CodecProvider)new CryptCodecProvider(password)).setReadOnly(true).open();
            db.setDateTimeType(DateTimeType.DATE);
            db.setLinkResolver(IGNORE_LINK_RESOLVER);
            JackcessExtractor ex = new JackcessExtractor(metadata, context, this.locale);
            ex.parse(db, xhtml);
        }
        catch (IllegalStateException e) {
            if (e.getMessage() != null && e.getMessage().contains("Incorrect password")) {
                throw new EncryptedDocumentException((Throwable)e);
            }
            throw e;
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (IOException iOException) {}
            }
        }
        xhtml.endDocument();
    }

    private static final class IgnoreLinkResolver
    implements LinkResolver {
        private IgnoreLinkResolver() {
        }

        public Database resolveLinkedDatabase(Database database, String s) throws IOException {
            throw new AssertionError((Object)"DO NOT ALLOW RESOLVING OF LINKS!!!");
        }
    }
}

