/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.solr.handler.extraction.ExtractionMetadata;
import org.apache.solr.handler.extraction.ExtractionRequest;
import org.apache.solr.handler.extraction.ExtractionResult;
import org.xml.sax.helpers.DefaultHandler;

public interface ExtractionBackend
extends Closeable {
    public ExtractionResult extract(InputStream var1, ExtractionRequest var2) throws Exception;

    public void extractWithSaxHandler(InputStream var1, ExtractionRequest var2, ExtractionMetadata var3, DefaultHandler var4) throws Exception;

    default public ExtractionMetadata buildMetadataFromRequest(ExtractionRequest request) {
        ExtractionMetadata md = new ExtractionMetadata();
        md.add("resourceName", request.resourceName);
        md.add("Content-Type", request.contentType);
        md.add("stream_name", request.streamName);
        md.add("stream_source_info", request.streamSourceInfo);
        md.add("stream_size", String.valueOf(request.streamSize));
        md.add("stream_content_type", request.contentType);
        md.add("Content-Encoding", request.charset);
        return md;
    }

    public String name();

    @Override
    default public void close() throws IOException {
    }
}

